/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject.transaction;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.transaction.TransactionCallback;
import org.jdbi.v3.core.transaction.TransactionException;
import org.jdbi.v3.core.transaction.TransactionIsolationLevel;
import org.jdbi.v3.sqlobject.Handler;
import org.jdbi.v3.sqlobject.HandlerDecorator;
import org.jdbi.v3.sqlobject.SqlMethodDecoratingAnnotation;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.METHOD})
@SqlMethodDecoratingAnnotation(value=Decorator.class)
public @interface Transaction {
    public TransactionIsolationLevel value() default TransactionIsolationLevel.INVALID_LEVEL;

    public static class Decorator
    implements HandlerDecorator {
        @Override
        public Handler decorateHandler(Handler base, Class<?> sqlObjectType, Method method) {
            TransactionIsolationLevel isolation = method.getAnnotation(Transaction.class).value();
            return (target, args, handle) -> {
                Handle h = handle.getHandle();
                if (h.isInTransaction()) {
                    TransactionIsolationLevel currentLevel = h.getTransactionIsolationLevel();
                    if (currentLevel == isolation || isolation == TransactionIsolationLevel.INVALID_LEVEL) {
                        return base.invoke(target, args, handle);
                    }
                    throw new TransactionException("Tried to execute nested @Transaction(" + isolation + "), " + "but already running in a transaction with isolation level " + currentLevel + ".");
                }
                TransactionCallback callback = th -> base.invoke(target, args, handle);
                if (isolation == TransactionIsolationLevel.INVALID_LEVEL) {
                    return h.inTransaction(callback);
                }
                return h.inTransaction(isolation, callback);
            };
        }
    }
}

