/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject.config;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.function.Consumer;
import org.jdbi.v3.core.config.ConfigRegistry;
import org.jdbi.v3.core.mapper.JoinRowMapper;
import org.jdbi.v3.core.mapper.RowMapper;
import org.jdbi.v3.core.mapper.RowMappers;
import org.jdbi.v3.sqlobject.config.ConfigurerFactory;
import org.jdbi.v3.sqlobject.config.ConfiguringAnnotation;

@ConfiguringAnnotation(value=Factory.class)
@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.TYPE, ElementType.METHOD})
public @interface RegisterJoinRowMapper {
    public Class<?>[] value();

    public static class Factory
    implements ConfigurerFactory {
        @Override
        public Consumer<ConfigRegistry> createForMethod(Annotation annotation, Class<?> sqlObjectType, Method method) {
            return this.create((RegisterJoinRowMapper)annotation);
        }

        @Override
        public Consumer<ConfigRegistry> createForType(Annotation annotation, Class<?> sqlObjectType) {
            return this.create((RegisterJoinRowMapper)annotation);
        }

        private Consumer<ConfigRegistry> create(RegisterJoinRowMapper annotation) {
            return config -> ((RowMappers)config.get(RowMappers.class)).register((RowMapper)JoinRowMapper.forTypes((Type[])annotation.value()));
        }
    }
}

