/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import org.jdbi.v3.core.HandleSupplier;
import org.jdbi.v3.sqlobject.Handler;

class DefaultMethodHandler
implements Handler {
    private static final Map<Class<?>, MethodHandles.Lookup> privateLookups = Collections.synchronizedMap(new WeakHashMap());
    private final MethodHandle methodHandle;

    private static MethodHandles.Lookup lookupFor(Class<?> clazz) {
        return privateLookups.computeIfAbsent(clazz, type -> {
            try {
                Constructor constructor = MethodHandles.Lookup.class.getDeclaredConstructor(Class.class, Integer.TYPE);
                if (!constructor.isAccessible()) {
                    constructor.setAccessible(true);
                }
                return (MethodHandles.Lookup)constructor.newInstance(type, 2);
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException(e);
            }
        });
    }

    DefaultMethodHandler(Method method) {
        try {
            Class<?> declaringClass = method.getDeclaringClass();
            this.methodHandle = DefaultMethodHandler.lookupFor(declaringClass).unreflectSpecial(method, declaringClass);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Object invoke(Object target, Object[] args, HandleSupplier handle) {
        try {
            return this.methodHandle.bindTo(target).invokeWithArguments(args);
        }
        catch (Error | RuntimeException e) {
            throw e;
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }
}

