/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject;

import java.lang.reflect.Method;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.HandleSupplier;
import org.jdbi.v3.core.exception.TransactionException;
import org.jdbi.v3.core.transaction.TransactionCallback;
import org.jdbi.v3.core.transaction.TransactionIsolationLevel;
import org.jdbi.v3.sqlobject.Handler;
import org.jdbi.v3.sqlobject.SqlObjectConfig;
import org.jdbi.v3.sqlobject.Transaction;

class TransactionDecorator
implements Handler {
    private final Handler delegate;
    private final TransactionIsolationLevel isolation;

    TransactionDecorator(Handler delegate, Transaction tx) {
        this.delegate = delegate;
        this.isolation = tx.value();
    }

    @Override
    public Object invoke(Object target, Method method, Object[] args, SqlObjectConfig config, HandleSupplier handle) throws Exception {
        Handle h = handle.getHandle();
        if (h.isInTransaction()) {
            TransactionIsolationLevel currentLevel = h.getTransactionIsolationLevel();
            if (currentLevel == this.isolation || this.isolation == TransactionIsolationLevel.INVALID_LEVEL) {
                return this.delegate.invoke(target, method, args, config, handle);
            }
            throw new TransactionException("Tried to execute nested @Transaction(" + this.isolation + "), but already running in a transaction with isolation level " + currentLevel + ".");
        }
        TransactionCallback callback = (conn, status) -> this.delegate.invoke(target, method, args, config, handle);
        if (this.isolation == TransactionIsolationLevel.INVALID_LEVEL) {
            return h.inTransaction(callback);
        }
        return h.inTransaction(this.isolation, callback);
    }
}

