/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject;

import java.lang.reflect.Type;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.jdbi.v3.core.StatementContext;
import org.jdbi.v3.core.mapper.ColumnMapper;
import org.jdbi.v3.core.mapper.RowMapper;

class DefaultGeneratedKeyMapper
implements RowMapper<Object> {
    private final Type returnType;
    private final String columnName;

    DefaultGeneratedKeyMapper(Type returnType, String columnName) {
        this.returnType = returnType;
        this.columnName = columnName;
    }

    public Object map(ResultSet r, StatementContext ctx) throws SQLException {
        ColumnMapper columnMapper = ctx.findColumnMapperFor(this.returnType).orElse(null);
        if (columnMapper != null) {
            return "".equals(this.columnName) ? columnMapper.map(r, 1, ctx) : columnMapper.map(r, this.columnName, ctx);
        }
        RowMapper rowMapper = ctx.findRowMapperFor(this.returnType).orElse(null);
        if (rowMapper != null) {
            return rowMapper.map(r, ctx);
        }
        throw new IllegalStateException("No column or row mapper for " + this.returnType);
    }
}

