/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jdbi.v3.sqlobject.Binder;
import org.jdbi.v3.sqlobject.BinderFactory;
import org.jdbi.v3.sqlobject.BindingAnnotation;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.PARAMETER})
@BindingAnnotation(value=Factory.class)
public @interface BindMap {
    public String value() default "";

    public String[] keys() default {};

    public boolean convertKeys() default false;

    public static class Factory
    implements BinderFactory<BindMap, Map<?, ?>> {
        @Override
        public Binder<BindMap, Map<?, ?>> build(BindMap annotation) {
            List<String> keys = Arrays.asList(annotation.keys());
            String prefix = annotation.value().isEmpty() ? "" : annotation.value() + ".";
            return (statement, param, index, bind, map) -> {
                HashMap m = new HashMap();
                map.forEach((k, v) -> {
                    if (annotation.convertKeys() || k instanceof String) {
                        String key = k.toString();
                        if (keys.isEmpty() || keys.contains(key)) {
                            m.put(prefix + key, v);
                        }
                    } else {
                        throw new IllegalArgumentException("Key " + k + " (of " + k.getClass() + ") must be a String");
                    }
                });
                keys.forEach(key -> m.putIfAbsent(prefix + key, null));
                statement.bindMap(m);
            };
        }
    }
}

