/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject;

import java.lang.reflect.Method;
import java.util.function.Supplier;
import org.jdbi.v3.Handle;
import org.jdbi.v3.Query;
import org.jdbi.v3.SqlStatement;
import org.jdbi.v3.sqlobject.CustomizingStatementHandler;
import org.jdbi.v3.sqlobject.ResultReturnThing;
import org.jdbi.v3.sqlobject.SqlAnnotations;
import org.jdbi.v3.sqlobject.SqlQuery;

class QueryHandler
extends CustomizingStatementHandler {
    private final String sql;
    private final ResultReturnThing magic;

    QueryHandler(Class<?> sqlObjectType, Method method, ResultReturnThing magic) {
        super(sqlObjectType, method);
        this.magic = magic;
        this.sql = SqlAnnotations.getSql(method.getAnnotation(SqlQuery.class), method);
    }

    @Override
    public Object invoke(Supplier<Handle> handle, Object target, Object[] args, Method method) {
        Query q = handle.get().createQuery(this.sql);
        this.populateSqlObjectData(q.getContext());
        this.applyCustomizers((SqlStatement<?>)q, args);
        this.applyBinders((SqlStatement<?>)q, args);
        return this.magic.map(method, q, handle);
    }
}

