/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject;

import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.Iterator;
import org.jdbi.v3.PreparedBatchPart;
import org.jdbi.v3.SqlStatement;
import org.jdbi.v3.sqlobject.Bind;
import org.jdbi.v3.sqlobject.Binder;
import org.jdbi.v3.util.GenericTypes;

class DefaultObjectBinder
implements Binder<Bind, Object> {
    DefaultObjectBinder() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void bind(SqlStatement<?> q, Parameter param, int index, Bind b, Object arg) {
        String bindName;
        if (b == null || b.value().equals("___use_param_name___")) {
            if (!param.isNamePresent()) throw new UnsupportedOperationException("A parameter was not given a name, and parameter name data is not present in the class file, for: " + param.getDeclaringExecutable() + " :: " + param);
            bindName = param.getName();
        } else {
            bindName = b.value();
        }
        Type type = param.getParameterizedType();
        if (q instanceof PreparedBatchPart) {
            Class erasedType = GenericTypes.getErasedType((Type)type);
            if (Iterable.class.isAssignableFrom(erasedType)) {
                type = (Type)GenericTypes.findGenericParameter((Type)type, Iterable.class).get();
            } else if (Iterator.class.isAssignableFrom(erasedType)) {
                type = (Type)GenericTypes.findGenericParameter((Type)type, Iterator.class).get();
            }
        }
        q.bindByType(index, arg, type);
        q.bindByType(bindName, arg, type);
    }
}

