/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.spring5;

import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jdbi.v3.spring5.EnableJdbiRepositories;
import org.jdbi.v3.spring5.JdbiRepository;
import org.jdbi.v3.spring5.JdbiRepositoryFactoryBean;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.annotation.AnnotatedGenericBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

@Deprecated(forRemoval=true, since="3.47.0")
public class JdbiRepositoryRegistrar
implements ImportBeanDefinitionRegistrar {
    public void registerBeanDefinitions(AnnotationMetadata metadata, BeanDefinitionRegistry registry) {
        EnableJdbiRepositories annotation = (EnableJdbiRepositories)metadata.getAnnotations().get(EnableJdbiRepositories.class).synthesize();
        String annotatedClass = metadata.getClassName();
        Iterable<BeanDefinition> repositoryBeanDefinitions = this.resolveRepositoryBeanDefinitions(annotation, annotatedClass);
        for (BeanDefinition repositoryBeanDefinition : repositoryBeanDefinitions) {
            AnnotationMetadata annotationMetadata = ((AnnotatedBeanDefinition)repositoryBeanDefinition).getMetadata();
            String repositoryClass = annotationMetadata.getClassName();
            JdbiRepository repositoryAnnotation = (JdbiRepository)annotationMetadata.getAnnotations().get(JdbiRepository.class).synthesize();
            this.registerJdbiRepositoryFactoryBean(registry, repositoryAnnotation, repositoryClass);
        }
    }

    private void registerJdbiRepositoryFactoryBean(BeanDefinitionRegistry registry, JdbiRepository annotation, String annotatedClass) {
        Class clazz = ClassUtils.resolveClassName((String)annotatedClass, null);
        String jdbiQualifier = StringUtils.hasText((String)annotation.jdbiQualifier()) ? annotation.jdbiQualifier() : null;
        String value = annotation.value();
        RootBeanDefinition beanDefinition = new RootBeanDefinition(JdbiRepositoryFactoryBean.class);
        beanDefinition.setTargetType(clazz);
        beanDefinition.getPropertyValues().add("objectType", (Object)clazz).add("jdbiQualifier", (Object)jdbiQualifier);
        beanDefinition.validate();
        String beanName = StringUtils.hasText((String)value) ? value : annotatedClass;
        registry.registerBeanDefinition(beanName, (BeanDefinition)beanDefinition);
    }

    private Iterable<BeanDefinition> resolveRepositoryBeanDefinitions(EnableJdbiRepositories annotation, String annotatedClass) {
        LinkedHashSet<BeanDefinition> repositoryDefinitions = new LinkedHashSet<BeanDefinition>();
        if (annotation.repositories().length > 0) {
            for (Class<?> clazz : annotation.repositories()) {
                repositoryDefinitions.add((BeanDefinition)new AnnotatedGenericBeanDefinition(clazz));
            }
        } else {
            ClassPathScanningCandidateComponentProvider scanner = this.createScanner();
            Set<String> basePackages = this.resolveBasePackages(annotation, annotatedClass);
            for (String basePackage : basePackages) {
                repositoryDefinitions.addAll(scanner.findCandidateComponents(basePackage));
            }
        }
        return repositoryDefinitions;
    }

    private Set<String> resolveBasePackages(EnableJdbiRepositories annotation, String annotatedClass) {
        HashSet<String> basePackages = new HashSet<String>();
        for (String pkg : annotation.value()) {
            if (!StringUtils.hasText((String)pkg)) continue;
            basePackages.add(pkg);
        }
        for (String pkg : annotation.basePackages()) {
            if (!StringUtils.hasText((String)pkg)) continue;
            basePackages.add(pkg);
        }
        for (Class<?> clazz : annotation.basePackageClasses()) {
            basePackages.add(ClassUtils.getPackageName((Class)clazz));
        }
        if (basePackages.isEmpty()) {
            basePackages.add(ClassUtils.getPackageName((String)annotatedClass));
        }
        return basePackages;
    }

    private ClassPathScanningCandidateComponentProvider createScanner() {
        ClassPathScanningCandidateComponentProvider scanner = new ClassPathScanningCandidateComponentProvider(){

            protected boolean isCandidateComponent(AnnotatedBeanDefinition beanDefinition) {
                return beanDefinition.getMetadata().isInterface();
            }
        };
        scanner.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(JdbiRepository.class));
        return scanner;
    }
}

