/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.spring5;

import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.spring5.JdbiJtaBinder;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.lang.Nullable;

public class JdbiRepositoryFactoryBean
implements FactoryBean<Object>,
ApplicationContextAware,
BeanFactoryAware,
InitializingBean {
    private Class<?> objectType;
    private String jdbiQualifier;
    private BeanFactory beanFactory;

    protected Jdbi getJdbi() {
        if (this.jdbiQualifier != null) {
            return (Jdbi)this.beanFactory.getBean(this.jdbiQualifier, Jdbi.class);
        }
        return (Jdbi)this.beanFactory.getBean(Jdbi.class);
    }

    public Object getObject() {
        return JdbiJtaBinder.bind(this.getJdbi(), this.objectType);
    }

    public Class<?> getObjectType() {
        return this.objectType;
    }

    public void setObjectType(Class<?> objectType) {
        this.objectType = objectType;
    }

    public void setJdbiQualifier(@Nullable String jdbiQualifier) {
        this.jdbiQualifier = jdbiQualifier;
    }

    public void afterPropertiesSet() {
        if (this.objectType == null) {
            throw new IllegalStateException("'type' property must be set");
        }
    }

    public void setApplicationContext(ApplicationContext context) {
        this.beanFactory = context;
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }
}

