/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.postgres;

import java.lang.reflect.Type;
import java.time.Duration;
import java.util.Optional;
import org.jdbi.v3.core.argument.Argument;
import org.jdbi.v3.core.argument.ArgumentFactory;
import org.jdbi.v3.core.argument.NullArgument;
import org.jdbi.v3.core.config.ConfigRegistry;
import org.postgresql.util.PGInterval;

public class DurationArgumentFactory
implements ArgumentFactory {
    public Optional<Argument> build(Type type, Object value, ConfigRegistry config) {
        long days;
        if (Duration.class != type) {
            return Optional.empty();
        }
        if (null == value) {
            return Optional.of(new NullArgument(1111));
        }
        Duration duration = (Duration)value;
        boolean isNegative = duration.isNegative();
        if (isNegative) {
            duration = duration.negated();
        }
        if ((days = duration.toDays()) > Integer.MAX_VALUE) {
            throw new IllegalArgumentException(String.format("duration %s too large to be represented unambiguously as postgres interval", duration));
        }
        duration = duration.minusDays(days);
        int hours = (int)duration.toHours();
        duration = duration.minusHours(hours);
        int minutes = (int)duration.toMinutes();
        if ((duration = duration.minusMinutes(minutes)).getNano() % 1000 != 0) {
            throw new IllegalArgumentException(String.format("duration %s too precise to represented as postgres interval", duration));
        }
        double seconds = (double)duration.getSeconds() + (double)duration.getNano() / 1.0E9;
        PGInterval interval = new PGInterval(0, 0, (int)days, hours, minutes, seconds);
        if (isNegative) {
            interval.scale(-1);
        }
        return Optional.of((i, p, cx) -> p.setObject(i, (Object)interval, 1111));
    }
}

