/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.cache.noop;

import org.jdbi.v3.cache.noop.NoopCacheBuilder;
import org.jdbi.v3.core.cache.JdbiCache;
import org.jdbi.v3.core.cache.JdbiCacheBuilder;
import org.jdbi.v3.core.cache.JdbiCacheLoader;

public final class NoopCache<K, V>
implements JdbiCache<K, V> {
    static final Object NOOP_CACHE_STATS = new Object();
    private final JdbiCacheLoader<K, V> cacheLoader;

    public static JdbiCacheBuilder builder() {
        return new NoopCacheBuilder();
    }

    NoopCache(JdbiCacheLoader<K, V> cacheLoader) {
        this.cacheLoader = cacheLoader;
    }

    public V get(K key) {
        if (this.cacheLoader != null) {
            return (V)this.cacheLoader.create(key);
        }
        throw new UnsupportedOperationException();
    }

    public V getWithLoader(K key, JdbiCacheLoader<K, V> loader) {
        return (V)loader.create(key);
    }

    public Object getStats() {
        return NOOP_CACHE_STATS;
    }
}

