/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.json.internal;

import java.lang.reflect.Type;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jdbi.v3.core.argument.Argument;
import org.jdbi.v3.core.argument.ArgumentFactory;
import org.jdbi.v3.core.argument.Arguments;
import org.jdbi.v3.core.config.ConfigRegistry;
import org.jdbi.v3.core.internal.JdbiOptionals;
import org.jdbi.v3.core.qualifier.QualifiedType;
import org.jdbi.v3.core.statement.UnableToCreateStatementException;
import org.jdbi.v3.json.EncodedJson;
import org.jdbi.v3.json.Json;
import org.jdbi.v3.json.JsonConfig;
import org.jdbi.v3.json.JsonMapper;

@Json
public class JsonArgumentFactory
implements ArgumentFactory.Preparable {
    public static final QualifiedType<String> ENCODED_JSON = QualifiedType.of(String.class).with(new Class[]{EncodedJson.class});
    private static final String JSON_NOT_STORABLE = String.format("No argument factory found for `@%s String` or 'String'", EncodedJson.class.getSimpleName());

    public Optional<Function<Object, Argument>> prepare(Type type, ConfigRegistry config) {
        JsonMapper.TypedJsonMapper mapper = ((JsonConfig)config.get(JsonConfig.class)).getJsonMapper().forType(type, config);
        Arguments a = (Arguments)config.get(Arguments.class);
        Function bindJson = (Function)JdbiOptionals.findFirstPresent((Supplier[])new Supplier[]{() -> a.prepareFor(ENCODED_JSON), () -> a.prepareFor(String.class)}).orElseThrow(() -> new UnableToCreateStatementException(JSON_NOT_STORABLE));
        return Optional.of(value -> {
            String nullableJson = value == null ? null : mapper.toJson(value, config);
            String json = "null".equals(nullableJson) ? null : nullableJson;
            return (Argument)bindJson.apply(json);
        });
    }
}

