/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.json.internal;

import java.lang.reflect.Type;
import java.util.Optional;
import java.util.function.Supplier;
import org.jdbi.v3.core.config.ConfigRegistry;
import org.jdbi.v3.core.internal.JdbiOptionals;
import org.jdbi.v3.core.mapper.ColumnMapper;
import org.jdbi.v3.core.mapper.ColumnMapperFactory;
import org.jdbi.v3.core.mapper.ColumnMappers;
import org.jdbi.v3.core.qualifier.QualifiedType;
import org.jdbi.v3.core.result.UnableToProduceResultException;
import org.jdbi.v3.json.Json;
import org.jdbi.v3.json.JsonConfig;
import org.jdbi.v3.json.JsonMapper;

@Json
public class JsonColumnMapperFactory
implements ColumnMapperFactory {
    private static final String JSON_NOT_RETRIEVABLE = String.format("No column mapper found for '@%s String', or 'String'", Json.class.getSimpleName());

    public Optional<ColumnMapper<?>> build(Type type, ConfigRegistry config) {
        if (String.class.equals((Object)type)) {
            return Optional.empty();
        }
        ColumnMappers cm = (ColumnMappers)config.get(ColumnMappers.class);
        ColumnMapper jsonStringMapper = (ColumnMapper)JdbiOptionals.findFirstPresent((Supplier[])new Supplier[]{() -> cm.findFor(QualifiedType.of(String.class).with(new Class[]{Json.class})), () -> cm.findFor(String.class)}).orElseThrow(() -> new UnableToProduceResultException(JSON_NOT_RETRIEVABLE));
        JsonMapper mapper = ((JsonConfig)config.get(JsonConfig.class)).getJsonMapper();
        return Optional.of((rs, i, ctx) -> mapper.fromJson(type, Optional.ofNullable((String)jsonStringMapper.map(rs, i, ctx)).orElse("null"), config));
    }
}

