/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.examples;

import com.google.common.base.Splitter;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.generic.GenericType;
import org.jdbi.v3.core.mapper.ColumnMapper;
import org.jdbi.v3.core.qualifier.QualifiedType;
import org.jdbi.v3.core.qualifier.Qualifier;
import org.jdbi.v3.core.statement.StatementContext;

public final class QualifiedTypes {
    private QualifiedTypes() {
        throw new AssertionError((Object)"do not instantiate");
    }

    public static void registerMappers(Jdbi jdbi) {
        jdbi.registerColumnMapper(QualifiedType.of((GenericType)new GenericType<List<String>>(){}).with(new Class[]{Colon.class}), (ColumnMapper)new ColonMapper());
        jdbi.registerColumnMapper(QualifiedType.of((GenericType)new GenericType<List<String>>(){}).with(new Class[]{Comma.class}), (ColumnMapper)new CommaMapper());
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.METHOD, ElementType.PARAMETER, ElementType.TYPE})
    @Qualifier
    public static @interface Colon {
    }

    public static class ColonMapper
    implements ColumnMapper<List<String>> {
        public List<String> map(ResultSet rs, int columnNumber, StatementContext ctx) throws SQLException {
            String value = rs.getString(columnNumber);
            if (value == null) {
                return null;
            }
            return Splitter.on((String)":").splitToList((CharSequence)value);
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.METHOD, ElementType.PARAMETER, ElementType.TYPE})
    @Qualifier
    public static @interface Comma {
    }

    public static class CommaMapper
    implements ColumnMapper<List<String>> {
        public List<String> map(ResultSet rs, int columnNumber, StatementContext ctx) throws SQLException {
            String value = rs.getString(columnNumber);
            if (value == null) {
                return null;
            }
            return Splitter.on((String)",").splitToList((CharSequence)value);
        }
    }
}

