/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.examples;

import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.List;
import org.jdbi.v3.examples.support.DatabaseSupport;
import org.jdbi.v3.sqlobject.SingleValue;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.sqlobject.statement.SqlUpdate;

public final class CustomSqlArrayType {
    private CustomSqlArrayType() {
        throw new AssertionError((Object)"CustomSqlArrayType can not be instantiated");
    }

    public static void main(String ... args) throws Exception {
        Instant[] testInstants = new Instant[]{Instant.EPOCH, Instant.now().truncatedTo(ChronoUnit.MILLIS), Instant.ofEpochSecond(Integer.MIN_VALUE), Instant.ofEpochSecond(Integer.MAX_VALUE), Instant.parse("1583-01-01T00:00:00Z"), Instant.parse("9999-12-31T23:59:59Z")};
        DatabaseSupport.withDatabase(jdbi -> {
            jdbi.inTransaction(th -> {
                th.execute("DROP TABLE IF EXISTS custom_sql", new Object[0]);
                th.execute("CREATE TABLE custom_sql (t TIMESTAMP[])", new Object[0]);
                return null;
            });
            jdbi.registerArrayType(Instant.class, "timestamp");
            CustomSqlObject dao = (CustomSqlObject)jdbi.onDemand(CustomSqlObject.class);
            dao.insertInstantArray(testInstants);
            List<Instant> result = dao.fetchInstantList();
            result.forEach(r -> System.out.printf("%s%n", r));
        });
    }

    static {
        System.setProperty("user.timezone", "UTC");
    }

    public static interface CustomSqlObject {
        @SqlUpdate(value="INSERT INTO custom_sql (t) VALUES (:instants)")
        public void insertInstantArray(Instant[] var1);

        @SqlQuery(value="SELECT t FROM custom_sql")
        @SingleValue
        public List<Instant> fetchInstantList();
    }
}

