/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.examples;

import com.google.common.base.Functions;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.function.Function;
import org.jdbi.v3.core.statement.Query;
import org.jdbi.v3.examples.order.Order;
import org.jdbi.v3.examples.order.OrderSupport;

public final class ResultsAsMultimap {
    private ResultsAsMultimap() {
        throw new AssertionError((Object)"ResultsAsMultimap can not be instantiated");
    }

    public static void main(String ... args) throws Exception {
        OrderSupport.withOrders(jdbi -> {
            List userIds = (List)jdbi.withHandle(handle -> handle.createQuery("SELECT DISTINCT user_id FROM orders LIMIT 5").mapTo(Integer.class).list());
            Multimap results = (Multimap)jdbi.withHandle(handle -> (ImmutableListMultimap)((Query)handle.createQuery("SELECT * from orders WHERE user_id IN (<user_id>)").bindList("user_id", (Iterable)userIds)).mapTo(Order.class).collect(ImmutableListMultimap.toImmutableListMultimap(Order::getUserId, (Function)Functions.identity())));
            results.asMap().forEach((k, v) -> System.out.printf("%d -> %s%n", k, v));
        });
    }
}

