/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.core.statement;

import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.Token;
import org.jdbi.v3.core.config.JdbiCache;
import org.jdbi.v3.core.config.JdbiCaches;
import org.jdbi.v3.core.internal.lexer.HashStatementLexer;
import org.jdbi.v3.core.statement.ParsedSql;
import org.jdbi.v3.core.statement.SqlParser;
import org.jdbi.v3.core.statement.StatementContext;
import org.jdbi.v3.core.statement.UnableToCreateStatementException;
import org.jdbi.v3.core.statement.internal.ErrorListener;

public class HashPrefixSqlParser
implements SqlParser {
    private static final JdbiCache<String, ParsedSql> PARSED_SQL_CACHE = JdbiCaches.declare(HashPrefixSqlParser::internalParse);

    @Override
    public ParsedSql parse(String sql, StatementContext ctx) {
        try {
            return PARSED_SQL_CACHE.get(sql, ctx);
        }
        catch (IllegalArgumentException e) {
            throw new UnableToCreateStatementException("Exception parsing for named parameter replacement", e, ctx);
        }
    }

    @Override
    public String nameParameter(String rawName, StatementContext ctx) {
        return "#" + rawName;
    }

    private static ParsedSql internalParse(String sql) {
        ParsedSql.Builder parsedSql = ParsedSql.builder();
        HashStatementLexer lexer = new HashStatementLexer((CharStream)CharStreams.fromString((String)sql));
        lexer.addErrorListener(new ErrorListener());
        Token t = lexer.nextToken();
        while (t.getType() != -1) {
            switch (t.getType()) {
                case 1: 
                case 2: 
                case 3: 
                case 7: {
                    parsedSql.append(t.getText());
                    break;
                }
                case 5: {
                    parsedSql.appendNamedParameter(t.getText().substring(1));
                    break;
                }
                case 6: {
                    parsedSql.appendPositionalParameter();
                    break;
                }
                case 4: {
                    parsedSql.append(t.getText().substring(1));
                    break;
                }
            }
            t = lexer.nextToken();
        }
        return parsedSql.build();
    }
}

