/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.core.internal;

import java.lang.annotation.Annotation;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jdbi.v3.core.internal.exceptions.Unchecked;

public class AnnotationFactory {
    private AnnotationFactory() {
    }

    public static <T extends Annotation> T create(Class<T> annotationType) {
        return AnnotationFactory.create(annotationType, Collections.emptyMap());
    }

    public static <T extends Annotation> T create(Class<T> annotationType, Map<String, ?> values) {
        Arrays.stream(annotationType.getDeclaredMethods()).filter(m -> m.getDefaultValue() == null).filter(m -> !values.containsKey(m.getName())).findAny().ifPresent(m -> {
            throw new IllegalArgumentException(String.format("Cannot synthesize annotation @%s from %s.class because it has attribute " + m.getName() + " without a default or specified value", annotationType.getSimpleName(), annotationType.getSimpleName()));
        });
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Class[] interfaces = new Class[]{annotationType};
        InvocationHandler invocationHandler = AnnotationFactory.getInvocationHandler(annotationType, values);
        Annotation annotation = (Annotation)Proxy.newProxyInstance(classLoader, interfaces, invocationHandler);
        return (T)annotation;
    }

    private static <T extends Annotation> InvocationHandler getInvocationHandler(Class<T> annotationType, Map<String, ?> values) {
        Function<Method, Object> getValue = method -> Optional.ofNullable(values.get(method.getName())).orElseGet(method::getDefaultValue);
        int hashCode = Arrays.stream(annotationType.getDeclaredMethods()).mapToInt(m -> AnnotationFactory.memberHash(m.getName(), getValue.apply((Method)m))).sum();
        String toString = "@" + annotationType.getName() + "(" + values.entrySet().stream().sorted(Comparator.comparing(Map.Entry::getKey)).map(e -> (String)e.getKey() + "=" + e.getValue()).collect(Collectors.joining(", ")) + ")";
        return (proxy, method, args) -> {
            String name = method.getName();
            if ("annotationType".equals(name) && method.getParameterCount() == 0) {
                return annotationType;
            }
            if ("equals".equals(name) && method.getParameterCount() == 1 && Object.class.equals(method.getParameterTypes()[0])) {
                Annotation that = (Annotation)args[0];
                return annotationType.equals(that.annotationType()) && AnnotationFactory.valuesEqual(annotationType, proxy, that);
            }
            if ("hashCode".equals(name) && method.getParameterCount() == 0) {
                return hashCode;
            }
            if ("toString".equals(name) && method.getParameterCount() == 0) {
                return toString;
            }
            if (method.getDeclaringClass() == annotationType) {
                return getValue.apply(method);
            }
            throw new IllegalStateException("Unknown method " + method + " for annotation type " + annotationType);
        };
    }

    private static int memberHash(String name, Object value) {
        return 127 * name.hashCode() ^ AnnotationFactory.valueHash(value);
    }

    private static int valueHash(Object value) {
        Class<?> valueClass = value.getClass();
        if (!valueClass.isArray()) {
            return value.hashCode();
        }
        return Unchecked.supplier(() -> MethodHandles.publicLookup().findStatic(Arrays.class, "hashCode", MethodType.methodType(Integer.TYPE, valueClass)).invoke(value)).get();
    }

    private static <A extends Annotation> boolean valuesEqual(Class<A> annotationType, Object a, Object b) {
        for (Method m : annotationType.getDeclaredMethods()) {
            Function<Object, Object> invoker = Unchecked.function(x$0 -> m.invoke(x$0, new Object[0]));
            Object valueA = invoker.apply(a);
            Object valueB = invoker.apply(b);
            if (valueA != null && valueB != null && valueA.getClass().isArray() && valueA.getClass().equals(valueB.getClass()) && Boolean.FALSE.equals(Unchecked.supplier(() -> MethodHandles.publicLookup().findStatic(Arrays.class, "equals", MethodType.methodType(Boolean.TYPE, valueA.getClass(), valueB.getClass())).invoke(a, b)).get())) {
                return false;
            }
            if (Objects.equals(valueA, valueB)) continue;
            return false;
        }
        return true;
    }
}

