/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.core.mapper.reflect.internal;

import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jdbi.v3.core.config.ConfigRegistry;
import org.jdbi.v3.core.config.JdbiCache;
import org.jdbi.v3.core.config.JdbiCaches;
import org.jdbi.v3.core.generic.GenericTypes;
import org.jdbi.v3.core.mapper.reflect.internal.PojoProperties;
import org.jdbi.v3.core.qualifier.QualifiedType;
import org.jdbi.v3.core.qualifier.Qualifiers;
import org.jdbi.v3.core.statement.UnableToCreateStatementException;

public class BeanPropertiesFactory {
    private static final JdbiCache<Type, Map<String, BeanPojoProperties.BeanPojoProperty<?>>> PROPERTY_CACHE = JdbiCaches.declare(BeanPropertiesFactory::getProperties0);
    private static final String TYPE_NOT_INSTANTIABLE = "A bean, %s, was mapped which was not instantiable";
    private static final String MISSING_SETTER = "No appropriate method to write property %s";
    private static final String SETTER_NOT_ACCESSIBLE = "Unable to access setter for property, %s";
    private static final String INVOCATION_TARGET_EXCEPTION = "Invocation target exception trying to invoker setter for the %s property";
    private static final String REFLECTION_ILLEGAL_ARGUMENT_EXCEPTION = "Write method of %s for property %s is not compatible with the value passed";

    private BeanPropertiesFactory() {
    }

    public static PojoProperties<?> propertiesFor(Type t, ConfigRegistry config) {
        return new BeanPojoProperties(t, config);
    }

    private static boolean shouldSeeProperty(PropertyDescriptor pd) {
        Method read = pd.getReadMethod();
        return read == null || read.getDeclaringClass() != Object.class;
    }

    private static Map<String, BeanPojoProperties.BeanPojoProperty<?>> getProperties0(Type t) {
        try {
            return Arrays.stream(Introspector.getBeanInfo(GenericTypes.getErasedType(t)).getPropertyDescriptors()).filter(BeanPropertiesFactory::shouldSeeProperty).map(BeanPojoProperties.BeanPojoProperty::new).collect(Collectors.toMap(PojoProperties.PojoProperty::getName, Function.identity()));
        }
        catch (IntrospectionException e) {
            throw new IllegalArgumentException("Failed to inspect bean " + t, e);
        }
    }

    static class BeanPojoProperties<T>
    extends PojoProperties<T> {
        private final ConfigRegistry config;

        BeanPojoProperties(Type type, ConfigRegistry config) {
            super(type);
            this.config = config;
        }

        @Override
        public Map<String, BeanPojoProperty<T>> getProperties() {
            return (Map)PROPERTY_CACHE.get(this.getType(), this.config);
        }

        @Override
        public PojoProperties.PojoBuilder<T> create() {
            Object instance;
            Class<?> type = GenericTypes.getErasedType(this.getType());
            try {
                instance = type.newInstance();
            }
            catch (Exception e) {
                throw new IllegalArgumentException(String.format(BeanPropertiesFactory.TYPE_NOT_INSTANTIABLE, type.getName()), e);
            }
            return new PojoProperties.PojoBuilder<T>(){

                @Override
                public void set(String property, Object value) {
                    BeanPojoProperty prop = this.getProperties().get(property);
                    try {
                        Method writeMethod = prop.descriptor.getWriteMethod();
                        if (writeMethod == null) {
                            throw new IllegalArgumentException(String.format(BeanPropertiesFactory.MISSING_SETTER, property));
                        }
                        writeMethod.invoke(instance, value);
                    }
                    catch (IllegalAccessException e) {
                        throw new IllegalArgumentException(String.format(BeanPropertiesFactory.SETTER_NOT_ACCESSIBLE, property), e);
                    }
                    catch (InvocationTargetException e) {
                        throw new IllegalArgumentException(String.format(BeanPropertiesFactory.INVOCATION_TARGET_EXCEPTION, property), e);
                    }
                    catch (IllegalArgumentException e) {
                        throw new IllegalArgumentException(String.format(BeanPropertiesFactory.REFLECTION_ILLEGAL_ARGUMENT_EXCEPTION, prop.getQualifiedType(), prop.getName()), e);
                    }
                }

                @Override
                public T build() {
                    return instance;
                }
            };
        }

        static class BeanPojoProperty<T>
        implements PojoProperties.PojoProperty<T> {
            final PropertyDescriptor descriptor;

            BeanPojoProperty(PropertyDescriptor property) {
                this.descriptor = property;
            }

            @Override
            public String getName() {
                return this.descriptor.getName();
            }

            @Override
            public QualifiedType<?> getQualifiedType() {
                Parameter setterParam = Optional.ofNullable(this.descriptor.getWriteMethod()).map(m -> m.getParameterCount() > 0 ? m.getParameters()[0] : null).orElse(null);
                return QualifiedType.of(Optional.ofNullable(this.descriptor.getReadMethod()).map(Method::getGenericReturnType).orElseGet(() -> this.descriptor.getWriteMethod().getGenericParameterTypes()[0])).withAnnotations(new Qualifiers().findFor(this.descriptor.getReadMethod(), this.descriptor.getWriteMethod(), setterParam));
            }

            @Override
            public <A extends Annotation> Optional<A> getAnnotation(Class<A> anno) {
                return Stream.of(this.descriptor.getReadMethod(), this.descriptor.getWriteMethod()).filter(Objects::nonNull).map(m -> m.getAnnotation(anno)).filter(Objects::nonNull).findFirst();
            }

            @Override
            public Object get(T pojo) {
                Method getter = this.descriptor.getReadMethod();
                if (getter == null) {
                    throw new UnableToCreateStatementException(String.format("No getter method found for bean property [%s] on [%s]", this.getName(), pojo));
                }
                try {
                    return getter.invoke(pojo, new Object[0]);
                }
                catch (IllegalAccessException e) {
                    throw new UnableToCreateStatementException(String.format("Access exception invoking method [%s] on [%s]", getter.getName(), pojo), e);
                }
                catch (InvocationTargetException e) {
                    throw new UnableToCreateStatementException(String.format("Invocation target exception invoking method [%s] on [%s]", getter.getName(), pojo), e);
                }
            }
        }
    }
}

