/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.core.mapper;

import java.lang.reflect.Type;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jdbi.v3.core.array.SqlArrayMapperFactory;
import org.jdbi.v3.core.config.ConfigRegistry;
import org.jdbi.v3.core.config.JdbiConfig;
import org.jdbi.v3.core.enums.internal.EnumMapperFactory;
import org.jdbi.v3.core.generic.GenericType;
import org.jdbi.v3.core.internal.JdbiOptionals;
import org.jdbi.v3.core.mapper.BoxedMapperFactory;
import org.jdbi.v3.core.mapper.ColumnMapper;
import org.jdbi.v3.core.mapper.ColumnMapperFactory;
import org.jdbi.v3.core.mapper.EssentialsMapperFactory;
import org.jdbi.v3.core.mapper.InferredColumnMapperFactory;
import org.jdbi.v3.core.mapper.InternetMapperFactory;
import org.jdbi.v3.core.mapper.JavaTimeMapperFactory;
import org.jdbi.v3.core.mapper.NVarcharMapper;
import org.jdbi.v3.core.mapper.OptionalMapperFactory;
import org.jdbi.v3.core.mapper.PrimitiveMapperFactory;
import org.jdbi.v3.core.mapper.QualifiedColumnMapperFactory;
import org.jdbi.v3.core.mapper.SqlTimeMapperFactory;
import org.jdbi.v3.core.qualifier.QualifiedType;
import org.jdbi.v3.meta.Beta;

public class ColumnMappers
implements JdbiConfig<ColumnMappers> {
    private final List<QualifiedColumnMapperFactory> factories = new CopyOnWriteArrayList<QualifiedColumnMapperFactory>();
    private final ConcurrentHashMap<QualifiedType<?>, ColumnMapper<?>> cache = new ConcurrentHashMap();
    private boolean coalesceNullPrimitivesToDefaults = true;
    private ConfigRegistry registry;

    public ColumnMappers() {
        this.register(new SqlArrayMapperFactory());
        this.register(new JavaTimeMapperFactory());
        this.register(new SqlTimeMapperFactory());
        this.register(new InternetMapperFactory());
        this.register(new EssentialsMapperFactory());
        this.register(new BoxedMapperFactory());
        this.register(new PrimitiveMapperFactory());
        this.register(new OptionalMapperFactory());
        this.register(new EnumMapperFactory());
        this.register(new NVarcharMapper());
    }

    @Override
    public void setRegistry(ConfigRegistry registry) {
        this.registry = registry;
    }

    private ColumnMappers(ColumnMappers that) {
        this.factories.addAll(that.factories);
        this.cache.putAll(that.cache);
        this.coalesceNullPrimitivesToDefaults = that.coalesceNullPrimitivesToDefaults;
    }

    public ColumnMappers register(ColumnMapper<?> mapper) {
        return this.register(new InferredColumnMapperFactory(mapper));
    }

    public <T> ColumnMappers register(GenericType<T> type, ColumnMapper<T> mapper) {
        return this.register(ColumnMapperFactory.of(type.getType(), mapper));
    }

    public ColumnMappers register(Type type, ColumnMapper<?> mapper) {
        return this.register(ColumnMapperFactory.of(type, mapper));
    }

    @Beta
    public <T> ColumnMappers register(QualifiedType<T> type, ColumnMapper<T> mapper) {
        return this.register(QualifiedColumnMapperFactory.of(type, mapper));
    }

    public ColumnMappers register(ColumnMapperFactory factory) {
        return this.register(QualifiedColumnMapperFactory.adapt(factory));
    }

    private ColumnMappers register(QualifiedColumnMapperFactory factory) {
        this.factories.add(0, factory);
        this.cache.clear();
        return this;
    }

    public <T> Optional<ColumnMapper<T>> findFor(Class<T> type) {
        ColumnMapper mapper = this.findFor((Type)type).orElse(null);
        return Optional.ofNullable(mapper);
    }

    public <T> Optional<ColumnMapper<T>> findFor(GenericType<T> type) {
        ColumnMapper mapper = this.findFor(type.getType()).orElse(null);
        return Optional.ofNullable(mapper);
    }

    public Optional<ColumnMapper<?>> findFor(Type type) {
        return this.findFor(QualifiedType.of(type)).map(m -> m);
    }

    @Beta
    public <T> Optional<ColumnMapper<T>> findFor(QualifiedType<T> type) {
        ColumnMapper<?> cached = this.cache.get(type);
        if (cached != null) {
            return Optional.of(cached);
        }
        Optional<ColumnMapper<ColumnMapper>> mapper = this.factories.stream().flatMap(factory -> JdbiOptionals.stream(factory.build(type, this.registry))).findFirst().map(m -> m);
        mapper.ifPresent(m -> this.cache.put(type, (ColumnMapper<?>)m));
        return mapper;
    }

    public boolean getCoalesceNullPrimitivesToDefaults() {
        return this.coalesceNullPrimitivesToDefaults;
    }

    public void setCoalesceNullPrimitivesToDefaults(boolean coalesceNullPrimitivesToDefaults) {
        this.coalesceNullPrimitivesToDefaults = coalesceNullPrimitivesToDefaults;
    }

    @Override
    public ColumnMappers createCopy() {
        return new ColumnMappers(this);
    }
}

