/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.core.array;

import java.lang.reflect.Type;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Function;
import org.jdbi.v3.core.array.InferredSqlArrayTypeFactory;
import org.jdbi.v3.core.array.SqlArrayArgumentStrategy;
import org.jdbi.v3.core.array.SqlArrayType;
import org.jdbi.v3.core.array.SqlArrayTypeFactory;
import org.jdbi.v3.core.config.ConfigRegistry;
import org.jdbi.v3.core.config.JdbiConfig;
import org.jdbi.v3.core.enums.internal.EnumSqlArrayTypeFactory;
import org.jdbi.v3.core.internal.JdbiOptionals;

public class SqlArrayTypes
implements JdbiConfig<SqlArrayTypes> {
    private final List<SqlArrayTypeFactory> factories = new CopyOnWriteArrayList<SqlArrayTypeFactory>();
    private SqlArrayArgumentStrategy argumentStrategy;
    private ConfigRegistry registry;

    public SqlArrayTypes() {
        this.argumentStrategy = SqlArrayArgumentStrategy.SQL_ARRAY;
        this.register(new EnumSqlArrayTypeFactory());
    }

    private SqlArrayTypes(SqlArrayTypes that) {
        this.factories.addAll(that.factories);
        this.argumentStrategy = that.argumentStrategy;
    }

    public SqlArrayArgumentStrategy getArgumentStrategy() {
        return this.argumentStrategy;
    }

    public SqlArrayTypes setArgumentStrategy(SqlArrayArgumentStrategy argumentStrategy) {
        this.argumentStrategy = argumentStrategy;
        return this;
    }

    public SqlArrayTypes register(Class<?> elementType, String sqlTypeName) {
        return this.register(SqlArrayTypeFactory.of(elementType, sqlTypeName, Function.identity()));
    }

    public SqlArrayTypes register(SqlArrayType<?> arrayType) {
        return this.register(new InferredSqlArrayTypeFactory(arrayType));
    }

    public SqlArrayTypes register(SqlArrayTypeFactory factory) {
        this.factories.add(0, factory);
        return this;
    }

    public Optional<SqlArrayType<?>> findFor(Type elementType) {
        return this.factories.stream().flatMap(factory -> JdbiOptionals.stream(factory.build(elementType, this.registry))).findFirst();
    }

    @Override
    public void setRegistry(ConfigRegistry registry) {
        this.registry = registry;
    }

    @Override
    public SqlArrayTypes createCopy() {
        return new SqlArrayTypes(this);
    }
}

