/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.core.mapper.reflect;

import java.beans.ConstructorProperties;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import org.jdbi.v3.core.mapper.Nested;
import org.jdbi.v3.core.mapper.RowMapper;
import org.jdbi.v3.core.mapper.RowMapperFactory;
import org.jdbi.v3.core.mapper.SingleColumnMapper;
import org.jdbi.v3.core.mapper.reflect.ColumnName;
import org.jdbi.v3.core.mapper.reflect.ColumnNameMatcher;
import org.jdbi.v3.core.mapper.reflect.JdbiConstructors;
import org.jdbi.v3.core.mapper.reflect.ReflectionMapperUtil;
import org.jdbi.v3.core.mapper.reflect.ReflectionMappers;
import org.jdbi.v3.core.statement.StatementContext;

public class ConstructorMapper<T>
implements RowMapper<T> {
    private static final String DEFAULT_PREFIX = "";
    private static final String UNMATCHED_CONSTRUCTOR_PARAMETERS = "Constructor '%s' could not match any parameter to any columns in the result set. Verify that the Java compiler is configured to emit parameter names, that your result set has the columns expected, annotate the parameter names explicitly with @ColumnName, or annotate nullable parameters as @Nullable";
    private static final String UNMATCHED_CONSTRUCTOR_PARAMETER = "Constructor '%s' parameter '%s' has no matching columns in the result set. Verify that the Java compiler is configured to emit parameter names, that your result set has the columns expected, annotate the parameter names explicitly with @ColumnName, or annotate nullable parameters as @Nullable";
    private static final String UNMATCHED_COLUMNS_STRICT = "Mapping constructor-injected type %s could not match parameters for columns: %s";
    private static final String MISSING_COLUMN_MAPPER = "Could not find column mapper for type '%s' of parameter '%s' for constructor '%s'";
    private final Constructor<T> constructor;
    private final String prefix;
    private final ConstructorProperties constructorProperties;
    private final Map<Parameter, ConstructorMapper<?>> nestedMappers = new ConcurrentHashMap();

    public static RowMapperFactory factory(Class<?> clazz) {
        return RowMapperFactory.of(clazz, ConstructorMapper.of(clazz));
    }

    public static RowMapperFactory factory(Class<?> clazz, String prefix) {
        return RowMapperFactory.of(clazz, ConstructorMapper.of(clazz, prefix));
    }

    public static RowMapperFactory factory(Constructor<?> constructor) {
        return RowMapperFactory.of(constructor.getDeclaringClass(), ConstructorMapper.of(constructor));
    }

    public static RowMapperFactory factory(Constructor<?> constructor, String prefix) {
        return RowMapperFactory.of(constructor.getDeclaringClass(), ConstructorMapper.of(constructor, prefix));
    }

    public static <T> RowMapper<T> of(Class<T> type) {
        return ConstructorMapper.of(JdbiConstructors.findConstructorFor(type));
    }

    public static <T> RowMapper<T> of(Class<T> type, String prefix) {
        return ConstructorMapper.of(JdbiConstructors.findConstructorFor(type), prefix);
    }

    public static <T> RowMapper<T> of(Constructor<T> constructor) {
        return ConstructorMapper.of(constructor, DEFAULT_PREFIX);
    }

    public static <T> RowMapper<T> of(Constructor<T> constructor, String prefix) {
        return new ConstructorMapper<T>(constructor, prefix);
    }

    private ConstructorMapper(Constructor<T> constructor, String prefix) {
        this.constructor = constructor;
        this.prefix = prefix.toLowerCase();
        this.constructorProperties = constructor.getAnnotation(ConstructorProperties.class);
    }

    @Override
    public T map(ResultSet rs, StatementContext ctx) throws SQLException {
        return this.specialize(rs, ctx).map(rs, ctx);
    }

    @Override
    public RowMapper<T> specialize(ResultSet rs, StatementContext ctx) throws SQLException {
        List<String> columnNames = ReflectionMapperUtil.getColumnNames(rs);
        List<ColumnNameMatcher> columnNameMatchers = ctx.getConfig(ReflectionMappers.class).getColumnNameMatchers();
        ArrayList<String> unmatchedColumns = new ArrayList<String>(columnNames);
        RowMapper<T> mapper = this.specialize0(ctx, columnNames, columnNameMatchers, unmatchedColumns).orElseThrow(() -> new IllegalArgumentException(String.format(UNMATCHED_CONSTRUCTOR_PARAMETERS, this.constructor)));
        if (ctx.getConfig(ReflectionMappers.class).isStrictMatching() && ReflectionMapperUtil.anyColumnsStartWithPrefix(unmatchedColumns, this.prefix, columnNameMatchers)) {
            throw new IllegalArgumentException(String.format(UNMATCHED_COLUMNS_STRICT, this.constructor.getDeclaringClass().getSimpleName(), unmatchedColumns));
        }
        return mapper;
    }

    private Optional<RowMapper<T>> specialize0(StatementContext ctx, List<String> columnNames, List<ColumnNameMatcher> columnNameMatchers, List<String> unmatchedColumns) {
        int count = this.constructor.getParameterCount();
        Parameter[] parameters = this.constructor.getParameters();
        RowMapper[] mappers = new RowMapper[count];
        boolean matchedColumns = false;
        ArrayList<String> unmatchedParameters = new ArrayList<String>();
        for (int i = 0; i < count; ++i) {
            Parameter parameter = parameters[i];
            boolean nullable = this.isNullable(parameter);
            Nested anno = parameter.getAnnotation(Nested.class);
            if (anno == null) {
                String paramName = this.prefix + ConstructorMapper.paramName(parameters, i, this.constructorProperties);
                OptionalInt columnIndex = ReflectionMapperUtil.findColumnIndex(paramName, columnNames, columnNameMatchers, () -> this.debugName(parameter));
                if (columnIndex.isPresent()) {
                    int colIndex = columnIndex.getAsInt();
                    Type type = parameter.getParameterizedType();
                    mappers[i] = ctx.findColumnMapperFor(type).map(mapper -> new SingleColumnMapper(mapper, colIndex + 1)).orElseThrow(() -> new IllegalArgumentException(String.format(MISSING_COLUMN_MAPPER, type, paramName, this.constructor)));
                    matchedColumns = true;
                    unmatchedColumns.remove(columnNames.get(colIndex));
                    continue;
                }
                if (nullable) {
                    mappers[i] = (r, c) -> null;
                    continue;
                }
                unmatchedParameters.add(paramName);
                continue;
            }
            String nestedPrefix = this.prefix + anno.value();
            Optional<RowMapper<T>> nestedMapper = this.nestedMappers.computeIfAbsent(parameter, p -> new ConstructorMapper(JdbiConstructors.findConstructorFor(p.getType()), nestedPrefix)).specialize0(ctx, columnNames, columnNameMatchers, unmatchedColumns);
            if (nestedMapper.isPresent()) {
                mappers[i] = nestedMapper.get();
                matchedColumns = true;
                continue;
            }
            if (nullable) {
                mappers[i] = (r, c) -> null;
                continue;
            }
            unmatchedParameters.add(ConstructorMapper.paramName(parameters, i, this.constructorProperties));
        }
        if (!matchedColumns) {
            return Optional.empty();
        }
        if (!unmatchedParameters.isEmpty()) {
            throw new IllegalArgumentException(String.format(UNMATCHED_CONSTRUCTOR_PARAMETER, this.constructor, unmatchedParameters));
        }
        return Optional.of((r, c) -> {
            Object[] params = new Object[count];
            for (int i = 0; i < count; ++i) {
                params[i] = mappers[i].map(r, c);
            }
            return this.construct(params);
        });
    }

    private boolean isNullable(Parameter parameter) {
        return Stream.of(parameter.getAnnotations()).map(Annotation::annotationType).map(Class::getSimpleName).anyMatch("Nullable"::equals);
    }

    private static String paramName(Parameter[] parameters, int position, ConstructorProperties parameterNames) {
        Parameter parameter = parameters[position];
        ColumnName dbName = parameter.getAnnotation(ColumnName.class);
        if (dbName != null) {
            return dbName.value();
        }
        if (parameterNames != null) {
            return parameterNames.value()[position];
        }
        return parameter.getName();
    }

    private String debugName(Parameter parameter) {
        return String.format("%s constructor parameter %s", this.constructor.getDeclaringClass().getSimpleName(), parameter.getName());
    }

    private T construct(Object[] params) {
        try {
            return this.constructor.newInstance(params);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            if (e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            if (e.getCause() instanceof Error) {
                throw (Error)e.getCause();
            }
            throw new RuntimeException(e);
        }
    }
}

