/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.core.locator;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.AbstractMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import net.jodah.expiringmap.ExpirationPolicy;
import net.jodah.expiringmap.ExpiringMap;
import org.antlr.runtime.ANTLRInputStream;
import org.antlr.runtime.CharStream;
import org.jdbi.v3.core.internal.SqlScriptParser;
import org.jdbi.v3.core.locator.internal.ClasspathBuilder;

public final class ClasspathSqlLocator {
    private static final SqlScriptParser SQL_SCRIPT_PARSER = new SqlScriptParser((t, sb) -> sb.append(t.getText()));
    private static final Map<Map.Entry<ClassLoader, String>, String> CACHE = ExpiringMap.builder().expiration(10L, TimeUnit.MINUTES).expirationPolicy(ExpirationPolicy.ACCESSED).entryLoader(obj -> {
        Map.Entry entry = (Map.Entry)obj;
        return ClasspathSqlLocator.readResource((ClassLoader)entry.getKey(), (String)entry.getValue());
    }).build();
    private static final String SQL_EXTENSION = "sql";

    private ClasspathSqlLocator() {
    }

    public static String findSqlOnClasspath(Class<?> type, String methodName) {
        String path = new ClasspathBuilder().appendFullyQualifiedClassName(type).appendVerbatim(methodName).setExtension(SQL_EXTENSION).build();
        return ClasspathSqlLocator.getResourceOnClasspath(type.getClassLoader(), path);
    }

    public static String findSqlOnClasspath(String name) {
        ClasspathBuilder builder = new ClasspathBuilder().appendDotPath(name).setExtension(SQL_EXTENSION);
        return ClasspathSqlLocator.getResourceOnClasspath(ClasspathSqlLocator.selectClassLoader(), builder.build());
    }

    public static String getResourceOnClasspath(String path) {
        return ClasspathSqlLocator.getResourceOnClasspath(ClasspathSqlLocator.selectClassLoader(), path);
    }

    public static String getResourceOnClasspath(ClassLoader classLoader, String path) {
        return CACHE.get(new AbstractMap.SimpleEntry<ClassLoader, String>(classLoader, path));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String readResource(ClassLoader classLoader, String path) {
        try (InputStream is = ClasspathSqlLocator.openStream(classLoader, path);){
            String string = SQL_SCRIPT_PARSER.parse((CharStream)new ANTLRInputStream(is));
            return string;
        }
        catch (IOException e) {
            throw new UncheckedIOException("Unable to read classpath resource at " + path, e);
        }
    }

    private static InputStream openStream(ClassLoader classLoader, String path) {
        InputStream is = classLoader.getResourceAsStream(path);
        if (is == null) {
            throw new IllegalArgumentException("Cannot find classpath resource at " + path);
        }
        return is;
    }

    private static ClassLoader selectClassLoader() {
        return Optional.ofNullable(Thread.currentThread().getContextClassLoader()).orElseGet(ClasspathSqlLocator.class::getClassLoader);
    }
}

