/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.core.statement;

import java.sql.SQLException;
import java.time.Instant;
import org.jdbi.v3.core.statement.SqlLoggable;
import org.jdbi.v3.core.statement.SqlLogger;
import org.jdbi.v3.core.statement.StatementContext;

class SqlLoggerUtil {
    private SqlLoggerUtil() {
        throw new UnsupportedOperationException("utility class");
    }

    static <T> T wrap(SqlLoggable<T> r, StatementContext ctx, SqlLogger logger) throws SQLException {
        try {
            ctx.setExecutionMoment(Instant.now());
            logger.logBeforeExecution(ctx);
            T result = r.invoke();
            ctx.setCompletionMoment(Instant.now());
            logger.logAfterExecution(ctx);
            return result;
        }
        catch (SQLException e) {
            ctx.setExceptionMoment(Instant.now());
            logger.logException(ctx, e);
            throw e;
        }
    }
}

