/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.core.mapper;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jdbi.v3.core.mapper.ColumnMapper;
import org.jdbi.v3.core.statement.StatementContext;

public abstract class EnumMapper<E extends Enum<E>>
implements ColumnMapper<E> {
    EnumMapper() {
    }

    public static <E extends Enum<E>> ColumnMapper<E> byName(Class<E> type) {
        return new ByName(type);
    }

    public static <E extends Enum<E>> ColumnMapper<E> byOrdinal(Class<E> type) {
        return new ByOrdinal(type);
    }

    private static class ByOrdinal<E extends Enum<E>>
    extends EnumMapper<E> {
        private final E[] constants;

        private ByOrdinal(Class<E> type) {
            this.constants = (Enum[])type.getEnumConstants();
        }

        @Override
        public E map(ResultSet r, int columnNumber, StatementContext ctx) throws SQLException {
            int ordinal = r.getInt(columnNumber);
            return r.wasNull() ? null : (E)this.constants[ordinal];
        }
    }

    private static class ByName<E extends Enum<E>>
    extends EnumMapper<E> {
        private final Class<E> type;
        private final ConcurrentMap<String, E> insensitiveLookup = new ConcurrentHashMap<String, E>();

        private ByName(Class<E> type) {
            this.type = type;
        }

        @Override
        public E map(ResultSet r, int columnNumber, StatementContext ctx) throws SQLException {
            String name = r.getString(columnNumber);
            return (E)(name == null ? null : this.insensitiveLookup.computeIfAbsent(name, this::resolve));
        }

        private E resolve(String name) {
            try {
                return Enum.valueOf(this.type, name);
            }
            catch (IllegalArgumentException e) {
                IllegalArgumentException failure = e;
                for (Enum e2 : (Enum[])this.type.getEnumConstants()) {
                    if (!e2.name().equalsIgnoreCase(name)) continue;
                    return (E)e2;
                }
                throw failure;
            }
        }
    }
}

