/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.core.argument;

import java.lang.reflect.Type;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.jdbi.v3.core.argument.Argument;
import org.jdbi.v3.core.argument.Arguments;
import org.jdbi.v3.core.argument.NamedArgumentFinder;
import org.jdbi.v3.core.statement.StatementContext;
import org.jdbi.v3.core.statement.UnableToCreateStatementException;

abstract class ObjectPropertyNamedArgumentFinder
implements NamedArgumentFinder {
    final String prefix;
    final Object object;
    private final Map<String, Optional<NamedArgumentFinder>> childArgumentFinders = new ConcurrentHashMap<String, Optional<NamedArgumentFinder>>();

    ObjectPropertyNamedArgumentFinder(String prefix, Object object) {
        this.prefix = prefix == null || prefix.isEmpty() ? "" : prefix + ".";
        this.object = object;
    }

    @Override
    public final Optional<Argument> find(String name, StatementContext ctx) {
        if (name.startsWith(this.prefix)) {
            String actualName = name.substring(this.prefix.length());
            int separator = actualName.indexOf(46);
            if (separator != -1) {
                String parentName = actualName.substring(0, separator);
                String childName = actualName.substring(separator + 1);
                return this.childArgumentFinders.computeIfAbsent(parentName.endsWith("?") ? parentName.substring(0, parentName.length() - 1) : parentName, pn -> this.getValue((String)pn, ctx).map(typedValue -> this.getValueNested((TypedValue)typedValue, parentName, childName))).flatMap(arg -> arg.find(childName, ctx));
            }
            return this.getValue(actualName, ctx).map(tv -> ctx.findArgumentFor(tv.type, tv.value).orElseThrow(() -> new UnableToCreateStatementException(String.format("No argument factory registered for type [%s] for element [%s] on [%s]", tv.type, name, this.object), ctx)));
        }
        return Optional.empty();
    }

    private NamedArgumentFinder getValueNested(TypedValue typedValue, String parentName, String childName) {
        if (Objects.nonNull(typedValue.value)) {
            return this.getNestedArgumentFinder(typedValue.value);
        }
        if (parentName.endsWith("?")) {
            return (n, c) -> Optional.of(c.getConfig(Arguments.class).getUntypedNullArgument());
        }
        throw new IllegalArgumentException(String.format("Trying to bind nested argument [%s], but found nullpointer at [%s], may mark it as an optional with [%s]", childName, parentName, parentName + '?'));
    }

    abstract Optional<TypedValue> getValue(String var1, StatementContext var2);

    abstract NamedArgumentFinder getNestedArgumentFinder(Object var1);

    static class TypedValue {
        public final Type type;
        public final Object value;

        TypedValue(Type type, Object value) {
            this.type = type;
            this.value = value;
        }
    }
}

