/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.core.result.internal;

import java.lang.reflect.Type;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collector;
import org.jdbi.v3.core.generic.GenericTypes;
import org.jdbi.v3.core.mapper.RowMapper;
import org.jdbi.v3.core.result.ResultIterable;
import org.jdbi.v3.core.result.ResultIterator;
import org.jdbi.v3.core.result.ResultSetException;
import org.jdbi.v3.core.result.UnableToProduceResultException;
import org.jdbi.v3.core.result.internal.ResultSetResultIterator;
import org.jdbi.v3.core.statement.StatementContext;

public class ResultSetResultIterable<T>
implements ResultIterable<T> {
    private final RowMapper<T> mapper;
    private final StatementContext ctx;
    private final Supplier<ResultSet> resultSetSupplier;

    public ResultSetResultIterable(RowMapper<T> mapper, StatementContext ctx, Supplier<ResultSet> resultSetSupplier) {
        this.mapper = mapper;
        this.ctx = ctx;
        this.resultSetSupplier = resultSetSupplier;
    }

    @Override
    public ResultIterator<T> iterator() {
        try {
            return new ResultSetResultIterator<T>(this.resultSetSupplier, this.mapper, this.ctx);
        }
        catch (SQLException e) {
            throw new ResultSetException("Unable to iterate result set", e, this.ctx);
        }
    }

    @Override
    public <R> R collectInto(Type containerType) {
        Type type = containerType;
        if (containerType instanceof Class) {
            type = GenericTypes.parameterizeClass((Class)containerType, new Type[]{Object.class});
        }
        Collector<?, ?, ?> collector = this.ctx.findCollectorFor(type).orElseThrow(() -> new UnableToProduceResultException("Could not find collector for " + String.valueOf(containerType)));
        return (R)this.collect(collector);
    }

    @Override
    public List<T> collectIntoList() {
        return (List)this.collectInto((Type)((Object)List.class));
    }

    @Override
    public Set<T> collectIntoSet() {
        return (Set)this.collectInto((Type)((Object)Set.class));
    }
}

