/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.core.result;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.function.Supplier;
import org.jdbi.v3.core.config.JdbiConfig;
import org.jdbi.v3.core.result.NoResultsException;
import org.jdbi.v3.core.result.ResultBearing;
import org.jdbi.v3.core.result.ResultProducer;
import org.jdbi.v3.core.result.ResultSetException;
import org.jdbi.v3.core.result.internal.EmptyResultSet;
import org.jdbi.v3.core.statement.StatementContext;

public class ResultProducers
implements JdbiConfig<ResultProducers> {
    private boolean allowNoResults = false;

    public ResultProducers() {
    }

    private ResultProducers(ResultProducers that) {
        this.allowNoResults = that.allowNoResults;
    }

    public static ResultProducer<Integer> returningUpdateCount() {
        return (statementSupplier, ctx) -> {
            try (StatementContext unused = ctx;){
                Integer n = ((PreparedStatement)statementSupplier.get()).getUpdateCount();
                return n;
            }
        };
    }

    public static ResultProducer<Long> returningLargeUpdateCount() {
        return (statementSupplier, ctx) -> {
            try (StatementContext unused = ctx;){
                Long l = ((PreparedStatement)statementSupplier.get()).getLargeUpdateCount();
                return l;
            }
        };
    }

    public static ResultProducer<ResultBearing> returningResults() {
        return (statementSupplier, ctx) -> ResultProducers.createResultBearing(statementSupplier, Statement::getResultSet, ctx);
    }

    public static ResultProducer<ResultBearing> returningGeneratedKeys(String ... generatedKeyColumnNames) {
        return (preparedStatementSupplier, ctx) -> {
            ctx.setReturningGeneratedKeys(true);
            if (generatedKeyColumnNames.length > 0) {
                ctx.setGeneratedKeysColumnNames(generatedKeyColumnNames);
            }
            return ResultProducers.createResultBearing(preparedStatementSupplier, Statement::getGeneratedKeys, ctx);
        };
    }

    public static ResultBearing createResultBearing(Supplier<PreparedStatement> preparedStatementSupplier, ResultSetCreator resultSetCreator, StatementContext ctx) {
        return ResultBearing.of(() -> {
            try {
                ResultSet resultSet = resultSetCreator.createResultSet((Statement)preparedStatementSupplier.get());
                if (resultSet == null) {
                    if (ctx.getConfig(ResultProducers.class).allowNoResults) {
                        return new EmptyResultSet();
                    }
                    throw new NoResultsException("Statement returned no results", ctx);
                }
                ctx.addCleanable(resultSet::close);
                return resultSet;
            }
            catch (SQLException e) {
                throw new ResultSetException("Could not process result set", e, ctx);
            }
        }, ctx);
    }

    @Override
    public ResultProducers createCopy() {
        return new ResultProducers(this);
    }

    public ResultProducers allowNoResults(boolean allowNoResults) {
        this.allowNoResults = allowNoResults;
        return this;
    }

    @FunctionalInterface
    public static interface ResultSetCreator {
        public ResultSet createResultSet(Statement var1) throws SQLException;
    }
}

