/*
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.jdbi.v3.core.cache;

/**
 * Simple statistics about a {@link JdbiCache} instance. The values in this object are a snapshot of
 * the cache status. Calling any method multiple times should be cheap and constant time.
 */
public interface JdbiCacheStats {

    /**
     * Returns the current size of the cache.
     * @return The current size of the cache.
     */
    int cacheSize();

    /**
     * Returns the maximum size of the cache.
     * @return The maximum size of the cache.
     */
    int maxSize();
}
