/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.core.internal;

import java.lang.invoke.MethodHandles;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Optional;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.config.JdbiConfig;
import org.jdbi.v3.core.extension.Extensions;
import org.jdbi.v3.core.internal.JdbiClassUtils;
import org.jdbi.v3.core.internal.exceptions.Sneaky;

public class OnDemandExtensions
implements JdbiConfig<OnDemandExtensions> {
    private Factory onDemandExtensionFactory;

    public OnDemandExtensions() {
        this.onDemandExtensionFactory = (jdbi, extensionType, extraTypes) -> Optional.empty();
    }

    private OnDemandExtensions(OnDemandExtensions other) {
        this.onDemandExtensionFactory = other.onDemandExtensionFactory;
    }

    public OnDemandExtensions setFactory(Factory onDemandExtensionFactory) {
        this.onDemandExtensionFactory = onDemandExtensionFactory;
        return this;
    }

    public <E> E create(Jdbi jdbi, Class<E> extensionType, Class<?> ... extraTypes) {
        return extensionType.cast(this.onDemandExtensionFactory.onDemand(jdbi, extensionType, extraTypes).orElseGet(() -> this.createProxy(jdbi, extensionType, extraTypes)));
    }

    private Object createProxy(Jdbi jdbi, Class<?> extensionType, Class<?> ... extraTypes) {
        jdbi.getConfig(Extensions.class).onCreateProxy();
        InvocationHandler handler = (proxy, method, args) -> {
            if (JdbiClassUtils.EQUALS_METHOD.equals(method)) {
                return proxy == args[0];
            }
            if (JdbiClassUtils.HASHCODE_METHOD.equals(method)) {
                return System.identityHashCode(proxy);
            }
            if (JdbiClassUtils.TOSTRING_METHOD.equals(method)) {
                return "Jdbi on demand proxy for " + extensionType.getName() + "@" + Integer.toHexString(System.identityHashCode(proxy));
            }
            return jdbi.withExtension(extensionType, extension -> OnDemandExtensions.invoke(extension, method, args));
        };
        LinkedHashSet types = new LinkedHashSet();
        types.add(extensionType);
        types.addAll(Arrays.asList(extensionType.getInterfaces()));
        types.addAll(Arrays.asList(extraTypes));
        return Proxy.newProxyInstance(extensionType.getClassLoader(), types.toArray(new Class[0]), handler);
    }

    private static Object invoke(Object target, Method method, Object[] args) {
        try {
            if (Proxy.isProxyClass(target.getClass())) {
                return Proxy.getInvocationHandler(target).invoke(target, method, args);
            }
            return MethodHandles.lookup().unreflect(method).bindTo(target).invokeWithArguments(args);
        }
        catch (Throwable t) {
            throw Sneaky.throwAnyway(t);
        }
    }

    @Override
    public OnDemandExtensions createCopy() {
        return new OnDemandExtensions(this);
    }

    @FunctionalInterface
    public static interface Factory {
        public Optional<Object> onDemand(Jdbi var1, Class<?> var2, Class<?> ... var3);
    }
}

