/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.core.statement;

import java.io.Closeable;
import java.sql.SQLException;
import java.util.Collection;
import org.jdbi.v3.core.CloseException;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.config.ConfigRegistry;
import org.jdbi.v3.core.config.Configurable;
import org.jdbi.v3.core.statement.Cleanable;
import org.jdbi.v3.core.statement.SqlStatements;
import org.jdbi.v3.core.statement.StatementContext;
import org.jdbi.v3.core.statement.StatementCustomizer;
import org.jdbi.v3.core.statement.UnableToExecuteStatementException;
import org.jdbi.v3.meta.Beta;

abstract class BaseStatement<This>
implements Closeable,
Configurable<This> {
    final This typedThis = this;
    private final Handle handle;
    private final StatementContext ctx;

    BaseStatement(Handle handle) {
        this.handle = handle;
        ConfigRegistry config = handle.getConfig().createCopy();
        this.ctx = StatementContext.create(config, handle.getExtensionMethod());
        if (config.get(SqlStatements.class).isAttachAllStatementsForCleanup()) {
            BaseStatement.attachToHandleForCleanup(this.handle, this.ctx);
        }
    }

    public final Handle getHandle() {
        return this.handle;
    }

    @Override
    public ConfigRegistry getConfig() {
        return this.ctx.getConfig();
    }

    public final StatementContext getContext() {
        return this.ctx;
    }

    @Beta
    public final This attachToHandleForCleanup() {
        BaseStatement.attachToHandleForCleanup(this.handle, this.ctx);
        return this.typedThis;
    }

    private static void attachToHandleForCleanup(Handle handle, StatementContext context) {
        Cleanable statementCleanable = context::close;
        handle.addCleanable(statementCleanable);
        context.addCleanable(() -> handle.removeCleanable(statementCleanable));
    }

    protected final void cleanUpForException(SQLException e) {
        try {
            this.close();
        }
        catch (CloseException ce) {
            e.addSuppressed(ce.getCause());
        }
        catch (Exception e1) {
            e.addSuppressed(e1);
        }
    }

    void addCustomizers(Collection<StatementCustomizer> customizers) {
        customizers.forEach(this::addCustomizer);
    }

    final void callCustomizers(StatementCustomizerInvocation invocation) {
        for (StatementCustomizer customizer : this.getCustomizers()) {
            try {
                invocation.call(customizer);
            }
            catch (SQLException e) {
                throw new UnableToExecuteStatementException("Exception thrown in statement customization", e, this.ctx);
            }
        }
    }

    private Collection<StatementCustomizer> getCustomizers() {
        return this.getConfig(SqlStatements.class).getCustomizers();
    }

    @Override
    public void close() {
        this.getContext().close();
    }

    public final boolean equals(Object o) {
        return this == o;
    }

    public final int hashCode() {
        return super.hashCode() * 11;
    }

    @FunctionalInterface
    static interface StatementCustomizerInvocation {
        public void call(StatementCustomizer var1) throws SQLException;
    }
}

