/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.core.internal.exceptions;

import java.util.LinkedList;
import java.util.function.Function;
import org.jdbi.v3.core.internal.exceptions.CheckedSupplier;
import org.jdbi.v3.core.internal.exceptions.Sneaky;
import org.jdbi.v3.core.internal.exceptions.Unchecked;

public final class ThrowableSuppressor {
    private final LinkedList<Throwable> throwables = new LinkedList();

    public <T> T suppressAppend(CheckedSupplier<T> supplier, T defaultValue) {
        try {
            return supplier.get();
        }
        catch (Throwable t) {
            this.throwables.add(t);
            return defaultValue;
        }
    }

    public void suppressAppend(Unchecked.CheckedRunnable runnable) {
        try {
            runnable.run();
        }
        catch (Throwable t) {
            this.throwables.add(t);
        }
    }

    public <T> T suppressPrepend(CheckedSupplier<T> supplier, T defaultValue) {
        try {
            return supplier.get();
        }
        catch (Throwable t) {
            this.throwables.addFirst(t);
            return defaultValue;
        }
    }

    public void suppressPrepend(Unchecked.CheckedRunnable runnable) {
        try {
            runnable.run();
        }
        catch (Throwable t) {
            this.throwables.addFirst(t);
        }
    }

    public void attachToThrowable(Throwable throwable) {
        for (Throwable t : this.throwables) {
            throwable.addSuppressed(t);
        }
        this.throwables.clear();
    }

    public <T extends Throwable> void throwIfNecessary(Function<Throwable, T> function) throws T {
        if (!this.throwables.isEmpty()) {
            Throwable result = (Throwable)function.apply(this.throwables.removeFirst());
            this.attachToThrowable(result);
            throw result;
        }
    }

    public void throwIfNecessary() {
        if (!this.throwables.isEmpty()) {
            Throwable first = this.throwables.removeFirst();
            this.attachToThrowable(first);
            throw Sneaky.throwAnyway(first);
        }
    }
}

