/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.core.statement;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.jdbi.v3.core.result.ResultBearing;
import org.jdbi.v3.core.statement.StatementContext;

public class OutParameters {
    private final StatementContext ctx;
    private final Map<Object, Object> map = new HashMap<Object, Object>();

    OutParameters(StatementContext ctx) {
        this.ctx = ctx;
    }

    @Nullable
    public <T> T getObject(String name, Class<T> type) {
        return type.cast(this.getObject(name));
    }

    @Nullable
    public Object getObject(String name) {
        return this.map.get(name);
    }

    @Nullable
    public Object getObject(int position) {
        return this.map.get(position);
    }

    @Nullable
    public <T> T getObject(int pos, Class<T> type) {
        return type.cast(this.getObject(pos));
    }

    @Nullable
    public String getString(String name) {
        Object obj = this.map.get(name);
        if (obj == null) {
            if (!this.map.containsKey(name)) {
                throw new IllegalArgumentException(String.format("Parameter '%s' does not exist", name));
            }
            return null;
        }
        return obj.toString();
    }

    @Nullable
    public String getString(int pos) {
        Object obj = this.map.get(pos);
        if (obj == null) {
            if (!this.map.containsKey(pos)) {
                throw new IllegalArgumentException(String.format("Parameter at %d does not exist", pos));
            }
            return null;
        }
        return obj.toString();
    }

    @Nullable
    public byte[] getBytes(String name) {
        Object obj = this.map.get(name);
        if (obj == null) {
            if (!this.map.containsKey(name)) {
                throw new IllegalArgumentException(String.format("Parameter '%s' does not exist", name));
            }
            return null;
        }
        if (obj instanceof byte[]) {
            return (byte[])obj;
        }
        throw new IllegalArgumentException(String.format("Parameter '%s' is a %s, not a byte[]", name, obj.getClass()));
    }

    @Nullable
    public byte[] getBytes(int pos) {
        Object obj = this.map.get(pos);
        if (obj == null) {
            if (!this.map.containsKey(pos)) {
                throw new IllegalArgumentException(String.format("Parameter at %d does not exist", pos));
            }
            return null;
        }
        if (obj instanceof byte[]) {
            return (byte[])obj;
        }
        throw new IllegalArgumentException(String.format("Parameter at %d is a %s, not a byte[]", pos, obj.getClass()));
    }

    @Nullable
    public Integer getInt(String name) {
        Number n = this.getNumber(name);
        return n == null ? null : Integer.valueOf(n.intValue());
    }

    @Nullable
    public Integer getInt(int pos) {
        Number n = this.getNumber(pos);
        return n == null ? null : Integer.valueOf(n.intValue());
    }

    @Nullable
    public Long getLong(String name) {
        Number n = this.getNumber(name);
        return n == null ? null : Long.valueOf(n.longValue());
    }

    @Nullable
    public Long getLong(int pos) {
        Number n = this.getNumber(pos);
        return n == null ? null : Long.valueOf(n.longValue());
    }

    @Nullable
    public Short getShort(String name) {
        Number n = this.getNumber(name);
        return n == null ? null : Short.valueOf(n.shortValue());
    }

    @Nullable
    public Short getShort(int pos) {
        Number n = this.getNumber(pos);
        return n == null ? null : Short.valueOf(n.shortValue());
    }

    @Nullable
    public java.sql.Date getDate(String name) {
        Long epoch = this.getEpoch(name);
        if (epoch == null) {
            return null;
        }
        return new java.sql.Date(epoch);
    }

    @Nullable
    public java.sql.Date getDate(int pos) {
        Long epoch = this.getEpoch(pos);
        if (epoch == null) {
            return null;
        }
        return new java.sql.Date(epoch);
    }

    @Nullable
    public Timestamp getTimestamp(String name) {
        Long epoch = this.getEpoch(name);
        if (epoch == null) {
            return null;
        }
        return new Timestamp(epoch);
    }

    @Nullable
    public Timestamp getTimestamp(int pos) {
        Long epoch = this.getEpoch(pos);
        if (epoch == null) {
            return null;
        }
        return new Timestamp(epoch);
    }

    @Nullable
    public Double getDouble(String name) {
        Number n = this.getNumber(name);
        return n == null ? null : Double.valueOf(n.doubleValue());
    }

    @Nullable
    public Double getDouble(int pos) {
        Number n = this.getNumber(pos);
        return n == null ? null : Double.valueOf(n.doubleValue());
    }

    @Nullable
    public Float getFloat(String name) {
        Number n = this.getNumber(name);
        return n == null ? null : Float.valueOf(n.floatValue());
    }

    @Nullable
    public Float getFloat(int pos) {
        Number n = this.getNumber(pos);
        return n == null ? null : Float.valueOf(n.floatValue());
    }

    @Nonnull
    public ResultBearing getRowSet(String name) {
        return ResultBearing.of(() -> {
            ResultSet resultSet = this.getObject(name, ResultSet.class);
            this.ctx.addCleanable(resultSet::close);
            return resultSet;
        }, this.ctx);
    }

    @Nonnull
    public ResultBearing getRowSet(int pos) {
        return ResultBearing.of(() -> {
            ResultSet resultSet = this.getObject(pos, ResultSet.class);
            this.ctx.addCleanable(resultSet::close);
            return resultSet;
        }, this.ctx);
    }

    @Nullable
    private Number getNumber(String name) {
        Object obj = this.map.get(name);
        if (obj == null) {
            if (!this.map.containsKey(name)) {
                throw new IllegalArgumentException(String.format("Parameter '%s' does not exist", name));
            }
            return null;
        }
        if (obj instanceof Number) {
            return (Number)obj;
        }
        throw new IllegalArgumentException(String.format("Parameter '%s' is a %s, not a number", name, obj.getClass()));
    }

    @Nullable
    private Number getNumber(int pos) {
        Object obj = this.map.get(pos);
        if (obj == null) {
            if (!this.map.containsKey(pos)) {
                throw new IllegalArgumentException(String.format("Parameter %d does not exist", pos));
            }
            return null;
        }
        if (obj instanceof Number) {
            return (Number)obj;
        }
        throw new IllegalArgumentException(String.format("Parameter %d is a %s, not a number", pos, obj.getClass()));
    }

    @Nullable
    private Long getEpoch(String name) {
        Object obj = this.map.get(name);
        if (obj == null) {
            if (!this.map.containsKey(name)) {
                throw new IllegalArgumentException(String.format("Parameter '%s' does not exist", name));
            }
            return null;
        }
        if (obj instanceof Date) {
            return ((Date)obj).getTime();
        }
        throw new IllegalArgumentException(String.format("Parameter '%s' is a %s, not a Date", name, obj.getClass()));
    }

    @Nullable
    private Long getEpoch(int pos) {
        Object obj = this.map.get(pos);
        if (obj == null) {
            if (!this.map.containsKey(pos)) {
                throw new IllegalArgumentException(String.format("Parameter at %d does not exist", pos));
            }
            return null;
        }
        if (obj instanceof Date) {
            return ((Date)obj).getTime();
        }
        throw new IllegalArgumentException(String.format("Parameter at %d is a %s, not a Date", pos, obj.getClass()));
    }

    @Nonnull
    Map<Object, Object> getMap() {
        return this.map;
    }
}

