/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.core.result.internal;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.jdbi.v3.core.mapper.RowMapper;
import org.jdbi.v3.core.result.ResultIterator;
import org.jdbi.v3.core.result.ResultSetException;
import org.jdbi.v3.core.statement.StatementContext;

class ResultSetResultIterator<T>
implements ResultIterator<T> {
    private final ResultSet resultSet;
    private final RowMapper<T> rowMapper;
    private final StatementContext context;
    private volatile boolean alreadyAdvanced = false;
    private volatile boolean hasNext = false;
    private volatile boolean closed = false;

    ResultSetResultIterator(ResultSet resultSet, RowMapper<T> rowMapper, StatementContext context) throws SQLException {
        this.resultSet = Objects.requireNonNull(resultSet);
        this.rowMapper = rowMapper.specialize(resultSet, context);
        this.context = context;
    }

    @Override
    public void close() {
        this.closed = true;
        this.context.close();
    }

    @Override
    public boolean hasNext() {
        if (this.closed) {
            return false;
        }
        if (this.alreadyAdvanced) {
            return this.hasNext;
        }
        this.hasNext = this.safeNext();
        if (this.hasNext) {
            this.alreadyAdvanced = true;
        } else {
            this.close();
        }
        return this.hasNext;
    }

    @Override
    public T next() {
        if (this.closed) {
            throw new IllegalStateException("iterator is closed");
        }
        if (!this.hasNext()) {
            this.close();
            throw new NoSuchElementException("No element to advance to");
        }
        try {
            T t = this.rowMapper.map(this.resultSet, this.context);
            return t;
        }
        catch (SQLException e) {
            throw new ResultSetException("Exception thrown mapping result set into return type", e, this.context);
        }
        finally {
            this.alreadyAdvanced = this.safeNext();
            if (!this.alreadyAdvanced) {
                this.close();
            }
        }
    }

    @Override
    public StatementContext getContext() {
        return this.context;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Deleting from a result set iterator is not yet supported");
    }

    private boolean safeNext() {
        try {
            return this.resultSet.next();
        }
        catch (SQLException e) {
            throw new ResultSetException("Unable to advance result set", e, this.context);
        }
    }
}

