/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.core.internal.exceptions;

import edu.umd.cs.findbugs.annotations.CheckReturnValue;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.reflect.InvocationTargetException;
import org.jdbi.v3.core.internal.UtilityClassException;
import org.jdbi.v3.core.internal.exceptions.DummyException;

public class Sneaky {
    private Sneaky() {
        throw new UtilityClassException();
    }

    @CheckReturnValue
    @NonNull
    public static DummyException throwAnyway(Throwable t) {
        if (t instanceof Error) {
            throw (Error)t;
        }
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        if (t instanceof IOException) {
            throw new UncheckedIOException((IOException)t);
        }
        if (t instanceof InterruptedException) {
            Thread.currentThread().interrupt();
        } else if (t instanceof InvocationTargetException) {
            throw Sneaky.throwAnyway(t.getCause());
        }
        throw (RuntimeException)Sneaky.throwEvadingChecks(t);
    }

    private static <E extends Throwable> E throwEvadingChecks(Throwable throwable) throws E {
        throw throwable;
    }
}

