/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.core.statement;

import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.argument.Argument;
import org.jdbi.v3.core.argument.Arguments;
import org.jdbi.v3.core.argument.BeanPropertyArguments;
import org.jdbi.v3.core.argument.CharacterStreamArgument;
import org.jdbi.v3.core.argument.InputStreamArgument;
import org.jdbi.v3.core.argument.MapArguments;
import org.jdbi.v3.core.argument.NamedArgumentFinder;
import org.jdbi.v3.core.argument.NullArgument;
import org.jdbi.v3.core.argument.ObjectArgument;
import org.jdbi.v3.core.argument.ObjectFieldArguments;
import org.jdbi.v3.core.argument.ObjectMethodArguments;
import org.jdbi.v3.core.generic.GenericType;
import org.jdbi.v3.core.mapper.Mappers;
import org.jdbi.v3.core.mapper.RowMapper;
import org.jdbi.v3.core.statement.ArgumentBinder;
import org.jdbi.v3.core.statement.BaseStatement;
import org.jdbi.v3.core.statement.Binding;
import org.jdbi.v3.core.statement.Call;
import org.jdbi.v3.core.statement.ParsedSql;
import org.jdbi.v3.core.statement.SqlLoggerUtil;
import org.jdbi.v3.core.statement.SqlStatements;
import org.jdbi.v3.core.statement.StatementContext;
import org.jdbi.v3.core.statement.StatementCustomizers;
import org.jdbi.v3.core.statement.UnableToCreateStatementException;
import org.jdbi.v3.core.statement.UnableToExecuteStatementException;

public abstract class SqlStatement<This extends SqlStatement<This>>
extends BaseStatement<This> {
    private final Handle handle;
    private final String sql;
    private PreparedStatement stmt;

    SqlStatement(Handle handle, String sql) {
        super(handle);
        this.handle = handle;
        this.sql = sql;
        this.getContext().setConnection(handle.getConnection()).setRawSql(sql);
    }

    protected Binding getBinding() {
        return this.getContext().getBinding();
    }

    protected String getSql() {
        return this.sql;
    }

    public This setQueryTimeout(int seconds) {
        return (This)((SqlStatement)this.addCustomizer(StatementCustomizers.statementTimeout(seconds)));
    }

    public This cleanupHandleCommit() {
        return this.cleanupHandle(Handle::commit);
    }

    public This cleanupHandleRollback() {
        return this.cleanupHandle(Handle::rollback);
    }

    private This cleanupHandle(Consumer<Handle> action) {
        this.addCleanable(() -> {
            if (this.handle != null) {
                if (this.handle.isInTransaction()) {
                    action.accept(this.handle);
                }
                this.handle.close();
            }
        });
        return (This)((SqlStatement)this.typedThis);
    }

    public This bind(int position, Argument argument) {
        this.getBinding().addPositional(position, argument);
        return (This)this;
    }

    public This bind(String name, Argument argument) {
        this.getBinding().addNamed(name, argument);
        return (This)((SqlStatement)this.typedThis);
    }

    public This bindBean(Object bean) {
        return this.bindNamedArgumentFinder(new BeanPropertyArguments(null, bean));
    }

    public This bindBean(String prefix, Object bean) {
        return this.bindNamedArgumentFinder(new BeanPropertyArguments(prefix, bean));
    }

    public This bindFields(Object object) {
        return this.bindNamedArgumentFinder(new ObjectFieldArguments(null, object));
    }

    public This bindFields(String prefix, Object object) {
        return this.bindNamedArgumentFinder(new ObjectFieldArguments(prefix, object));
    }

    public This bindMethods(Object object) {
        return this.bindNamedArgumentFinder(new ObjectMethodArguments(null, object));
    }

    public This bindMethods(String prefix, Object object) {
        return this.bindNamedArgumentFinder(new ObjectMethodArguments(prefix, object));
    }

    public This bindMap(Map<String, ?> map) {
        return (This)(map == null ? (SqlStatement)this.typedThis : this.bindNamedArgumentFinder(new MapArguments(map)));
    }

    public This bindNamedArgumentFinder(NamedArgumentFinder namedArgumentFinder) {
        if (namedArgumentFinder != null) {
            this.getBinding().addNamedArgumentFinder(namedArgumentFinder);
        }
        return (This)((SqlStatement)this.typedThis);
    }

    public final This bind(int position, Character value) {
        return this.bind(position, this.toArgument((Type)((Object)Character.class), value));
    }

    public final This bind(String name, Character value) {
        return this.bind(name, this.toArgument((Type)((Object)Character.class), value));
    }

    public final This bind(int position, String value) {
        return this.bind(position, this.toArgument((Type)((Object)String.class), value));
    }

    public final This bind(String name, String value) {
        return this.bind(name, this.toArgument((Type)((Object)String.class), value));
    }

    public final This bind(int position, int value) {
        return this.bind(position, this.toArgument(Integer.TYPE, value));
    }

    public final This bind(int position, Integer value) {
        return this.bind(position, this.toArgument((Type)((Object)Integer.class), value));
    }

    public final This bind(String name, int value) {
        return this.bind(name, this.toArgument(Integer.TYPE, value));
    }

    public final This bind(String name, Integer value) {
        return this.bind(name, this.toArgument((Type)((Object)Integer.class), value));
    }

    public final This bind(int position, char value) {
        return this.bind(position, this.toArgument(Character.TYPE, Character.valueOf(value)));
    }

    public final This bind(String name, char value) {
        return this.bind(name, this.toArgument(Character.TYPE, Character.valueOf(value)));
    }

    public final This bindASCIIStream(int position, InputStream value, int length) {
        return this.bind(position, (Argument)new InputStreamArgument(value, length, true));
    }

    public final This bindASCIIStream(String name, InputStream value, int length) {
        return this.bind(name, (Argument)new InputStreamArgument(value, length, true));
    }

    public final This bind(int position, BigDecimal value) {
        return this.bind(position, this.toArgument((Type)((Object)BigDecimal.class), value));
    }

    public final This bind(String name, BigDecimal value) {
        return this.bind(name, this.toArgument((Type)((Object)BigDecimal.class), value));
    }

    public final This bindBinaryStream(int position, InputStream value, int length) {
        return this.bind(position, (Argument)new InputStreamArgument(value, length, false));
    }

    public final This bindBinaryStream(String name, InputStream value, int length) {
        return this.bind(name, (Argument)new InputStreamArgument(value, length, false));
    }

    public final This bind(int position, Blob value) {
        return this.bind(position, this.toArgument((Type)((Object)Blob.class), value));
    }

    public final This bind(String name, Blob value) {
        return this.bind(name, this.toArgument((Type)((Object)Blob.class), value));
    }

    public final This bind(int position, boolean value) {
        return this.bind(position, this.toArgument(Boolean.TYPE, value));
    }

    public final This bind(int position, Boolean value) {
        return this.bind(position, this.toArgument((Type)((Object)Boolean.class), value));
    }

    public final This bind(String name, boolean value) {
        return this.bind(name, this.toArgument(Boolean.TYPE, value));
    }

    public final This bind(String name, Boolean value) {
        return this.bind(name, this.toArgument((Type)((Object)Boolean.class), value));
    }

    public final This bind(int position, byte value) {
        return this.bind(position, this.toArgument(Byte.TYPE, value));
    }

    public final This bind(int position, Byte value) {
        return this.bind(position, this.toArgument((Type)((Object)Byte.class), value));
    }

    public final This bind(String name, byte value) {
        return this.bind(name, this.toArgument(Byte.TYPE, value));
    }

    public final This bind(String name, Byte value) {
        return this.bind(name, this.toArgument((Type)((Object)Byte.class), value));
    }

    public final This bind(int position, byte[] value) {
        return this.bind(position, this.toArgument((Type)((Object)byte[].class), value));
    }

    public final This bind(String name, byte[] value) {
        return this.bind(name, this.toArgument((Type)((Object)byte[].class), value));
    }

    public final This bind(int position, Reader value, int length) {
        return this.bind(position, (Argument)new CharacterStreamArgument(value, length));
    }

    public final This bind(String name, Reader value, int length) {
        return this.bind(name, (Argument)new CharacterStreamArgument(value, length));
    }

    public final This bind(int position, Clob value) {
        return this.bind(position, this.toArgument((Type)((Object)Clob.class), value));
    }

    public final This bind(String name, Clob value) {
        return this.bind(name, this.toArgument((Type)((Object)Clob.class), value));
    }

    public final This bind(int position, Date value) {
        return this.bind(position, this.toArgument((Type)((Object)Date.class), value));
    }

    public final This bind(String name, Date value) {
        return this.bind(name, this.toArgument((Type)((Object)Date.class), value));
    }

    public final This bind(int position, java.util.Date value) {
        return this.bind(position, this.toArgument((Type)((Object)java.util.Date.class), value));
    }

    public final This bind(String name, java.util.Date value) {
        return this.bind(name, this.toArgument((Type)((Object)java.util.Date.class), value));
    }

    public final This bind(int position, double value) {
        return this.bind(position, this.toArgument(Double.TYPE, value));
    }

    public final This bind(int position, Double value) {
        return this.bind(position, this.toArgument((Type)((Object)Double.class), value));
    }

    public final This bind(String name, double value) {
        return this.bind(name, this.toArgument(Double.TYPE, value));
    }

    public final This bind(String name, Double value) {
        return this.bind(name, this.toArgument((Type)((Object)Double.class), value));
    }

    public final This bind(int position, float value) {
        return this.bind(position, this.toArgument(Float.TYPE, Float.valueOf(value)));
    }

    public final This bind(int position, Float value) {
        return this.bind(position, this.toArgument((Type)((Object)Float.class), value));
    }

    public final This bind(String name, float value) {
        return this.bind(name, this.toArgument(Float.TYPE, Float.valueOf(value)));
    }

    public final This bind(String name, Float value) {
        return this.bind(name, this.toArgument((Type)((Object)Float.class), value));
    }

    public final This bind(int position, long value) {
        return this.bind(position, this.toArgument(Long.TYPE, value));
    }

    public final This bind(int position, Long value) {
        return this.bind(position, this.toArgument((Type)((Object)Long.class), value));
    }

    public final This bind(String name, long value) {
        return this.bind(name, this.toArgument(Long.TYPE, value));
    }

    public final This bind(String name, Long value) {
        return this.bind(name, this.toArgument((Type)((Object)Long.class), value));
    }

    public final This bind(int position, Short value) {
        return this.bind(position, this.toArgument((Type)((Object)Short.class), value));
    }

    public final This bind(int position, short value) {
        return this.bind(position, this.toArgument(Short.TYPE, value));
    }

    public final This bind(String name, short value) {
        return this.bind(name, this.toArgument(Short.TYPE, value));
    }

    public final This bind(String name, Short value) {
        return this.bind(name, this.toArgument(Short.TYPE, value));
    }

    public final This bind(int position, Object value) {
        return this.bind(position, this.toArgument(value));
    }

    public final This bind(String name, Object value) {
        return this.bind(name, this.toArgument(value));
    }

    public final This bind(int position, Time value) {
        return this.bind(position, this.toArgument((Type)((Object)Time.class), value));
    }

    public final This bind(String name, Time value) {
        return this.bind(name, this.toArgument((Type)((Object)Time.class), value));
    }

    public final This bind(int position, Timestamp value) {
        return this.bind(position, this.toArgument((Type)((Object)Timestamp.class), value));
    }

    public final This bind(String name, Timestamp value) {
        return this.bind(name, this.toArgument((Type)((Object)Timestamp.class), value));
    }

    public final This bind(int position, URL value) {
        return this.bind(position, this.toArgument((Type)((Object)URL.class), value));
    }

    public final This bind(String name, URL value) {
        return this.bind(name, this.toArgument((Type)((Object)URL.class), value));
    }

    public final This bindByType(int position, Object value, Type argumentType) {
        return this.bind(position, this.toArgument(argumentType, value));
    }

    public final This bindByType(int position, Object value, GenericType<?> argumentType) {
        return this.bindByType(position, value, argumentType.getType());
    }

    public final This bindByType(String name, Object value, Type argumentType) {
        return this.bind(name, this.toArgument(argumentType, value));
    }

    public final This bindByType(String name, Object value, GenericType<?> argumentType) {
        return this.bindByType(name, value, argumentType.getType());
    }

    private Argument toArgument(Object value) {
        return this.toArgument((Type)((Object)(value == null ? Object.class : value.getClass())), value);
    }

    private Argument toArgument(Type type, final Object value) {
        final Argument arg = this.getConfig(Arguments.class).findFor(type, value).orElseThrow(() -> this.factoryNotFound(type, value));
        try {
            boolean toStringIsImplementedInArgument;
            boolean bl = toStringIsImplementedInArgument = arg.getClass().getMethod("toString", new Class[0]).getDeclaringClass() != Object.class;
            if (toStringIsImplementedInArgument) {
                return arg;
            }
            return new Argument(){

                @Override
                public void apply(int position, PreparedStatement statement, StatementContext ctx) throws SQLException {
                    arg.apply(position, statement, ctx);
                }

                public String toString() {
                    return Objects.toString(value);
                }
            };
        }
        catch (NoSuchMethodException e) {
            throw new Error("toString method does not exist, Object hierarchy is corrupt", e);
        }
    }

    private UnsupportedOperationException factoryNotFound(Type type, Object value) {
        Object[] params;
        if (type instanceof Class && (params = ((Class)type).getTypeParameters()).length > 0) {
            return new UnsupportedOperationException("No type parameters found for erased type '" + type + Arrays.toString(params) + "'. To bind a generic type, prefer using bindByType.");
        }
        return new UnsupportedOperationException("No argument factory registered for '" + value + "' of type " + type);
    }

    public final This bindNull(String name, int sqlType) {
        return this.bind(name, (Argument)new NullArgument(sqlType));
    }

    public final This bindNull(int position, int sqlType) {
        return this.bind(position, (Argument)new NullArgument(sqlType));
    }

    public final This bindBySqlType(String name, Object value, int sqlType) {
        return this.bind(name, (Argument)new ObjectArgument(value, sqlType));
    }

    public final This bindBySqlType(int position, Object value, int sqlType) {
        return this.bind(position, (Argument)new ObjectArgument(value, sqlType));
    }

    public final This bindList(String key, Object ... values) {
        if (values.length == 0) {
            throw new IllegalArgumentException(this.getClass().getSimpleName() + ".bindList was called with no vararg values.");
        }
        return this.bindList(key, Arrays.asList(values));
    }

    public final This bindList(String key, List<?> values) {
        if (values.isEmpty()) {
            throw new IllegalArgumentException(this.getClass().getSimpleName() + ".bindList was called with an empty list.");
        }
        StringBuilder names = new StringBuilder();
        for (int i = 0; i < values.size(); ++i) {
            String name = "__" + key + "_" + i;
            if (i > 0) {
                names.append(',');
            }
            String paramName = this.getConfig().get(SqlStatements.class).getSqlParser().nameParameter(name, this.getContext());
            names.append(paramName);
            this.bind(name, values.get(i));
        }
        return (This)((SqlStatement)this.define(key, names.toString()));
    }

    public final This bindBeanList(String key, List<?> values, List<String> propertyNames) throws UnableToCreateStatementException {
        if (values.isEmpty()) {
            throw new IllegalArgumentException(this.getClass().getSimpleName() + ".bindBeanList was called with no values.");
        }
        if (propertyNames.isEmpty()) {
            throw new IllegalArgumentException(this.getClass().getSimpleName() + ".bindBeanList was called with no properties.");
        }
        StringBuilder names = new StringBuilder();
        StatementContext ctx = this.getContext();
        for (int valueIndex = 0; valueIndex < values.size(); ++valueIndex) {
            if (valueIndex > 0) {
                names.append(',');
            }
            Object bean = values.get(valueIndex);
            BeanPropertyArguments beanProperties = new BeanPropertyArguments(null, bean);
            names.append("(");
            for (int propertyIndex = 0; propertyIndex < propertyNames.size(); ++propertyIndex) {
                if (propertyIndex > 0) {
                    names.append(",");
                }
                String propertyName = propertyNames.get(propertyIndex);
                String name = "__" + key + "_" + valueIndex + "_" + propertyName;
                names.append(':').append(name);
                Argument argument = beanProperties.find(propertyName, ctx).orElseThrow(() -> new UnableToCreateStatementException("Unable to get " + propertyName + " argument for " + bean, ctx));
                this.bind(name, argument);
            }
            names.append(")");
        }
        return (This)((SqlStatement)this.define(key, names.toString()));
    }

    public final This defineList(String key, Object ... values) {
        if (values.length == 0) {
            throw new IllegalArgumentException(this.getClass().getSimpleName() + ".defineList was called with no vararg values.");
        }
        if (Stream.of(values).anyMatch(Objects::isNull)) {
            throw new IllegalArgumentException(this.getClass().getSimpleName() + ".defineList was called with a vararg array containing null values.");
        }
        return this.defineList(key, Arrays.asList(values));
    }

    public final This defineList(String key, List<?> values) {
        if (values.isEmpty()) {
            throw new IllegalArgumentException(this.getClass().getSimpleName() + ".defineList was called with an empty list.");
        }
        if (values.contains(null)) {
            throw new IllegalArgumentException(this.getClass().getSimpleName() + ".defineList was called with a list containing null values.");
        }
        String value = values.stream().map(Object::toString).collect(Collectors.joining(", "));
        return (This)((SqlStatement)this.define(key, value));
    }

    PreparedStatement internalExecute() {
        String renderedSql = this.getConfig(SqlStatements.class).getTemplateEngine().render(this.sql, this.getContext());
        this.getContext().setRenderedSql(renderedSql);
        ParsedSql parsedSql = this.getConfig(SqlStatements.class).getSqlParser().parse(renderedSql, this.getContext());
        String sql = parsedSql.getSql();
        this.getContext().setParsedSql(parsedSql);
        try {
            this.stmt = this.getClass().isAssignableFrom(Call.class) ? this.handle.getStatementBuilder().createCall(this.handle.getConnection(), sql, this.getContext()) : this.handle.getStatementBuilder().create(this.handle.getConnection(), sql, this.getContext());
        }
        catch (SQLException e) {
            throw new UnableToCreateStatementException(e, this.getContext());
        }
        this.addCleanable(() -> this.handle.getStatementBuilder().close(this.handle.getConnection(), this.sql, this.stmt));
        this.getContext().setStatement(this.stmt);
        this.beforeBinding(this.stmt);
        ArgumentBinder.bind(parsedSql.getParameters(), this.getBinding(), this.stmt, this.getContext());
        this.beforeExecution(this.stmt);
        try {
            SqlLoggerUtil.wrap(this.stmt::execute, this.getContext(), this.getConfig(SqlStatements.class).getSqlLogger());
        }
        catch (SQLException e) {
            try {
                this.stmt.close();
            }
            catch (SQLException e1) {
                e.addSuppressed(e1);
            }
            throw new UnableToExecuteStatementException(e, this.getContext());
        }
        this.afterExecution(this.stmt);
        return this.stmt;
    }

    <T> RowMapper<T> mapperForType(Class<T> type) {
        return this.mapperForType((Type)type);
    }

    <T> RowMapper<T> mapperForType(GenericType<T> type) {
        return this.mapperForType(type.getType());
    }

    RowMapper<?> mapperForType(Type type) {
        return this.getConfig(Mappers.class).findFor(type).orElseThrow(() -> new UnsupportedOperationException("No mapper registered for " + type));
    }
}

