/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.core.mapper.reflect.internal;

import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.function.Supplier;
import org.jdbi.v3.core.config.ConfigRegistry;
import org.jdbi.v3.core.config.JdbiCache;
import org.jdbi.v3.core.config.JdbiCaches;
import org.jdbi.v3.core.generic.GenericTypes;
import org.jdbi.v3.core.internal.exceptions.CheckedBiConsumer;
import org.jdbi.v3.core.internal.exceptions.Unchecked;
import org.jdbi.v3.core.mapper.reflect.internal.BuilderPojoProperties;
import org.jdbi.v3.core.mapper.reflect.internal.PojoBuilderUtils;
import org.jdbi.v3.core.mapper.reflect.internal.PojoProperties;
import org.jdbi.v3.core.mapper.reflect.internal.PojoPropertiesFactory;
import org.jdbi.v3.core.qualifier.QualifiedType;
import org.jdbi.v3.core.qualifier.Qualifiers;

public interface ModifiablePojoPropertiesFactory
extends PojoPropertiesFactory {
    public static final JdbiCache<ModifiableSpec<?, ?>, ModifiablePojoProperties<?, ?>> MODIFIABLE_CACHE = JdbiCaches.declare(s -> s.type, ModifiablePojoProperties::new);

    public static <T, M extends T> PojoPropertiesFactory modifiable(Class<T> defn, Class<M> impl, Supplier<M> constructor) {
        return (t, config) -> MODIFIABLE_CACHE.get(new ModifiableSpec(t, config, defn, impl, constructor), config);
    }

    public static class ModifiableSpec<T, M> {
        Type type;
        ConfigRegistry config;
        Class<T> defn;
        Class<M> impl;
        Supplier<M> constructor;

        ModifiableSpec(Type type, ConfigRegistry config, Class<T> defn, Class<M> impl, Supplier<M> constructor) {
            this.type = type;
            this.config = config;
            this.defn = defn;
            this.impl = impl;
            this.constructor = constructor;
        }
    }

    public static class ModifiablePojoProperties<T, M>
    extends BuilderPojoProperties<T, M> {
        ModifiablePojoProperties(ModifiableSpec<T, M> spec) {
            super(spec.type, spec.config, spec.defn, spec.impl, spec.constructor);
        }

        @Override
        protected BuilderPojoProperties.BuilderPojoProperty<T> createProperty(String name, Method m) {
            Type propertyType = GenericTypes.resolveType(m.getGenericReturnType(), this.getType());
            try {
                return new BuilderPojoProperties.BuilderPojoProperty(name, QualifiedType.of(propertyType).withAnnotations(this.config.get(Qualifiers.class).findFor(m)), m, this.isSetMethod(name), MethodHandles.lookup().unreflect(m).asFixedArity(), MethodHandles.lookup().findVirtual(this.impl, this.setterName(name), MethodType.methodType(this.impl, GenericTypes.getErasedType(propertyType))).asFixedArity());
            }
            catch (IllegalAccessException | NoSuchMethodException e) {
                throw new IllegalArgumentException("Failed to inspect method " + m, e);
            }
        }

        private MethodHandle isSetMethod(String name) {
            try {
                return MethodHandles.lookup().findVirtual(this.impl, name + "IsSet", MethodType.methodType(Boolean.TYPE));
            }
            catch (NoSuchMethodException e) {
                return PojoBuilderUtils.alwaysSet();
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException("Failed to find IsSet method for " + name, e);
            }
        }

        private String setterName(String name) {
            return "set" + name.substring(0, 1).toUpperCase() + name.substring(1);
        }

        @Override
        public PojoProperties.PojoBuilder<T> create() {
            final Object instance = this.builder.get();
            return new PojoProperties.PojoBuilder<T>(){

                @Override
                public void set(String property, Object value) {
                    Unchecked.biConsumer((CheckedBiConsumer<Object, Object>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)V, invoke(java.lang.Object java.lang.Object ), (Ljava/lang/Object;Ljava/lang/Object;)V)((MethodHandle)this.getProperties().get((Object)property).setter)).accept(instance, value);
                }

                @Override
                public T build() {
                    return instance;
                }
            };
        }
    }
}

