/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.core.mapper.reflect;

import java.lang.reflect.Field;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.jdbi.v3.core.mapper.ColumnMapper;
import org.jdbi.v3.core.mapper.Nested;
import org.jdbi.v3.core.mapper.PropagateNull;
import org.jdbi.v3.core.mapper.RowMapper;
import org.jdbi.v3.core.mapper.RowMapperFactory;
import org.jdbi.v3.core.mapper.SingleColumnMapper;
import org.jdbi.v3.core.mapper.reflect.ColumnName;
import org.jdbi.v3.core.mapper.reflect.ColumnNameMatcher;
import org.jdbi.v3.core.mapper.reflect.ReflectionMapperUtil;
import org.jdbi.v3.core.mapper.reflect.ReflectionMappers;
import org.jdbi.v3.core.mapper.reflect.internal.PojoMapper;
import org.jdbi.v3.core.qualifier.QualifiedType;
import org.jdbi.v3.core.qualifier.Qualifiers;
import org.jdbi.v3.core.statement.StatementContext;

public class FieldMapper<T>
implements RowMapper<T> {
    private static final String DEFAULT_PREFIX = "";
    private final Class<T> type;
    private final String prefix;
    private final Map<Field, FieldMapper<?>> nestedMappers = new ConcurrentHashMap();

    public static RowMapperFactory factory(Class<?> type) {
        return RowMapperFactory.of(type, FieldMapper.of(type));
    }

    public static RowMapperFactory factory(Class<?> type, String prefix) {
        return RowMapperFactory.of(type, FieldMapper.of(type, prefix));
    }

    public static <T> RowMapper<T> of(Class<T> type) {
        return FieldMapper.of(type, DEFAULT_PREFIX);
    }

    public static <T> RowMapper<T> of(Class<T> type, String prefix) {
        return new FieldMapper<T>(type, prefix);
    }

    private FieldMapper(Class<T> type, String prefix) {
        this.type = type;
        this.prefix = prefix.toLowerCase();
    }

    @Override
    public T map(ResultSet rs, StatementContext ctx) throws SQLException {
        return this.specialize(rs, ctx).map(rs, ctx);
    }

    @Override
    public RowMapper<T> specialize(ResultSet rs, StatementContext ctx) throws SQLException {
        List<String> columnNames = ReflectionMapperUtil.getColumnNames(rs);
        List<ColumnNameMatcher> columnNameMatchers = ctx.getConfig(ReflectionMappers.class).getColumnNameMatchers();
        ArrayList<String> unmatchedColumns = new ArrayList<String>(columnNames);
        RowMapper<T> mapper = this.specialize0(ctx, columnNames, columnNameMatchers, unmatchedColumns).orElseThrow(() -> new IllegalArgumentException(String.format("Mapping fields for type %s didn't find any matching columns in result set", this.type)));
        if (ctx.getConfig(ReflectionMappers.class).isStrictMatching() && ReflectionMapperUtil.anyColumnsStartWithPrefix(unmatchedColumns, this.prefix, columnNameMatchers)) {
            throw new IllegalArgumentException(String.format("Mapping type %s could not match fields for columns: %s", this.type.getSimpleName(), unmatchedColumns));
        }
        return mapper;
    }

    private Optional<RowMapper<T>> specialize0(StatementContext ctx, List<String> columnNames, List<ColumnNameMatcher> columnNameMatchers, List<String> unmatchedColumns) {
        ArrayList fields = new ArrayList();
        for (Class<T> aType = this.type; aType != null; aType = aType.getSuperclass()) {
            for (Field field : aType.getDeclaredFields()) {
                Nested anno = field.getAnnotation(Nested.class);
                if (anno == null) {
                    String paramName = this.prefix + FieldMapper.paramName(field);
                    ReflectionMapperUtil.findColumnIndex(paramName, columnNames, columnNameMatchers, () -> this.debugName(field)).ifPresent(index -> {
                        QualifiedType<?> fieldType = QualifiedType.of(field.getGenericType()).withAnnotations(ctx.getConfig(Qualifiers.class).findFor(field));
                        ColumnMapper<Object> mapper = ctx.findColumnMapperFor(fieldType).orElse((r, n, c) -> r.getObject(n));
                        fields.add(new FieldData(field, new SingleColumnMapper<Object>(mapper, index + 1)));
                        unmatchedColumns.remove(columnNames.get(index));
                    });
                    continue;
                }
                String nestedPrefix = this.prefix + anno.value().toLowerCase();
                if (!ReflectionMapperUtil.anyColumnsStartWithPrefix(columnNames, nestedPrefix, columnNameMatchers)) continue;
                this.nestedMappers.computeIfAbsent(field, f -> new FieldMapper(field.getType(), nestedPrefix)).specialize0(ctx, columnNames, columnNameMatchers, unmatchedColumns).ifPresent(mapper -> fields.add(new FieldData(field, (RowMapper<?>)mapper)));
            }
        }
        if (fields.isEmpty() && !columnNames.isEmpty()) {
            return Optional.empty();
        }
        Collections.sort(fields, Comparator.comparing(f -> f.propagateNull ? 1 : 0));
        Optional<String> nullMarkerColumn = Optional.ofNullable(this.type.getAnnotation(PropagateNull.class)).map(PropagateNull::value);
        return Optional.of((r, c) -> {
            if (PojoMapper.propagateNull(r, nullMarkerColumn)) {
                return null;
            }
            T obj = this.construct();
            for (FieldData f : fields) {
                Object value = f.mapper.map(r, ctx);
                if (f.propagateNull && (value == null || f.isPrimitive && r.wasNull())) {
                    return null;
                }
                this.writeField(obj, f.field, value);
            }
            return obj;
        });
    }

    private static String paramName(Field field) {
        return Optional.ofNullable(field.getAnnotation(ColumnName.class)).map(ColumnName::value).orElseGet(field::getName);
    }

    private String debugName(Field field) {
        return String.format("%s.%s", this.type.getSimpleName(), field.getName());
    }

    private T construct() {
        try {
            return this.type.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new IllegalArgumentException(String.format("A type, %s, was mapped which was not instantiable", this.type.getName()), e);
        }
    }

    private void writeField(T obj, Field field, Object value) {
        try {
            field.setAccessible(true);
            field.set(obj, value);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException(String.format("Unable to access property, %s", field.getName()), e);
        }
    }

    private static class FieldData {
        final Field field;
        final RowMapper<?> mapper;
        final boolean propagateNull;
        final boolean isPrimitive;

        FieldData(Field field, RowMapper<?> mapper) {
            this.field = field;
            this.mapper = mapper;
            this.propagateNull = field.getAnnotation(PropagateNull.class) != null;
            this.isPrimitive = field.getType().isPrimitive();
        }
    }
}

