/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.core.statement;

import com.github.benmanes.caffeine.cache.Caffeine;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.Token;
import org.jdbi.v3.core.internal.lexer.ColonStatementLexer;
import org.jdbi.v3.core.statement.CachingSqlParser;
import org.jdbi.v3.core.statement.ParsedSql;
import org.jdbi.v3.core.statement.StatementContext;
import org.jdbi.v3.core.statement.internal.ErrorListener;
import org.jdbi.v3.meta.Beta;

public class ColonPrefixSqlParser
extends CachingSqlParser {
    public ColonPrefixSqlParser() {
    }

    @Beta
    public ColonPrefixSqlParser(Caffeine<Object, Object> cache) {
        super(cache);
    }

    @Override
    public String nameParameter(String rawName, StatementContext ctx) {
        return ":" + rawName;
    }

    @Override
    ParsedSql internalParse(String sql) {
        ParsedSql.Builder parsedSql = ParsedSql.builder();
        ColonStatementLexer lexer = new ColonStatementLexer((CharStream)CharStreams.fromString((String)sql));
        lexer.addErrorListener(new ErrorListener());
        Token t = lexer.nextToken();
        while (t.getType() != -1) {
            switch (t.getType()) {
                case 1: 
                case 2: 
                case 3: 
                case 7: {
                    parsedSql.append(t.getText());
                    break;
                }
                case 5: {
                    parsedSql.appendNamedParameter(t.getText().substring(1));
                    break;
                }
                case 6: {
                    parsedSql.appendPositionalParameter();
                    break;
                }
                case 4: {
                    parsedSql.append(t.getText().substring(1));
                    break;
                }
            }
            t = lexer.nextToken();
        }
        return parsedSql.build();
    }
}

