/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.core.mapper.reflect;

import java.beans.ConstructorProperties;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Parameter;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import org.jdbi.v3.core.mapper.Nested;
import org.jdbi.v3.core.mapper.PropagateNull;
import org.jdbi.v3.core.mapper.RowMapper;
import org.jdbi.v3.core.mapper.RowMapperFactory;
import org.jdbi.v3.core.mapper.SingleColumnMapper;
import org.jdbi.v3.core.mapper.reflect.ColumnName;
import org.jdbi.v3.core.mapper.reflect.ColumnNameMatcher;
import org.jdbi.v3.core.mapper.reflect.ConstructorInstanceFactory;
import org.jdbi.v3.core.mapper.reflect.InstanceFactory;
import org.jdbi.v3.core.mapper.reflect.JdbiConstructors;
import org.jdbi.v3.core.mapper.reflect.ReflectionMapperUtil;
import org.jdbi.v3.core.mapper.reflect.ReflectionMappers;
import org.jdbi.v3.core.mapper.reflect.internal.PojoMapper;
import org.jdbi.v3.core.qualifier.QualifiedType;
import org.jdbi.v3.core.qualifier.Qualifiers;
import org.jdbi.v3.core.statement.StatementContext;

public class ConstructorMapper<T>
implements RowMapper<T> {
    private static final String DEFAULT_PREFIX = "";
    private static final String UNMATCHED_CONSTRUCTOR_PARAMETERS = "Instance factory '%s' could not match any parameter to any columns in the result set. Verify that the Java compiler is configured to emit parameter names, that your result set has the columns expected, annotate the parameter names explicitly with @ColumnName, or annotate nullable parameters as @Nullable";
    private static final String UNMATCHED_CONSTRUCTOR_PARAMETER = "Instance factory '%s' parameter '%s' has no matching columns in the result set. Verify that the Java compiler is configured to emit parameter names, that your result set has the columns expected, annotate the parameter names explicitly with @ColumnName, or annotate nullable parameters as @Nullable";
    private static final String UNMATCHED_COLUMNS_STRICT = "Mapping instance factory %s could not match parameters for columns: %s";
    private static final String MISSING_COLUMN_MAPPER = "Could not find column mapper for type '%s' of parameter '%s' for instance factory '%s'";
    private final InstanceFactory<T> factory;
    private final String prefix;
    private final ConstructorProperties constructorProperties;
    private final Map<Parameter, ConstructorMapper<?>> nestedMappers = new ConcurrentHashMap();

    public static RowMapperFactory factory(Class<?> clazz) {
        return RowMapperFactory.of(clazz, ConstructorMapper.of(clazz));
    }

    public static RowMapperFactory factory(Class<?> clazz, String prefix) {
        return RowMapperFactory.of(clazz, ConstructorMapper.of(clazz, prefix));
    }

    public static RowMapperFactory factory(Constructor<?> constructor) {
        return RowMapperFactory.of(constructor.getDeclaringClass(), ConstructorMapper.of(constructor));
    }

    public static RowMapperFactory factory(Constructor<?> constructor, String prefix) {
        return RowMapperFactory.of(constructor.getDeclaringClass(), ConstructorMapper.of(constructor, prefix));
    }

    public static <T> RowMapper<T> of(Class<T> type) {
        return ConstructorMapper.of(type, DEFAULT_PREFIX);
    }

    public static <T> RowMapper<T> of(Class<T> type, String prefix) {
        return new ConstructorMapper<T>(JdbiConstructors.findFactoryFor(type), prefix);
    }

    public static <T> RowMapper<T> of(Constructor<T> constructor) {
        return ConstructorMapper.of(constructor, DEFAULT_PREFIX);
    }

    public static <T> RowMapper<T> of(Constructor<T> constructor, String prefix) {
        return new ConstructorMapper<T>(new ConstructorInstanceFactory<T>(constructor), prefix);
    }

    private ConstructorMapper(InstanceFactory<T> factory, String prefix) {
        this.factory = factory;
        this.prefix = prefix.toLowerCase();
        this.constructorProperties = factory.getAnnotation(ConstructorProperties.class);
    }

    @Override
    public T map(ResultSet rs, StatementContext ctx) throws SQLException {
        return this.specialize(rs, ctx).map(rs, ctx);
    }

    @Override
    public RowMapper<T> specialize(ResultSet rs, StatementContext ctx) throws SQLException {
        List<String> columnNames = ReflectionMapperUtil.getColumnNames(rs);
        List<ColumnNameMatcher> columnNameMatchers = ctx.getConfig(ReflectionMappers.class).getColumnNameMatchers();
        ArrayList<String> unmatchedColumns = new ArrayList<String>(columnNames);
        RowMapper mapper = this.specialize0(ctx, columnNames, columnNameMatchers, unmatchedColumns).orElseGet(() -> new UnmatchedConstructorMapper(String.format(UNMATCHED_CONSTRUCTOR_PARAMETERS, this.factory)));
        if (ctx.getConfig(ReflectionMappers.class).isStrictMatching() && ReflectionMapperUtil.anyColumnsStartWithPrefix(unmatchedColumns, this.prefix, columnNameMatchers)) {
            return new UnmatchedConstructorMapper(String.format(UNMATCHED_COLUMNS_STRICT, this.factory, unmatchedColumns));
        }
        return mapper;
    }

    private Optional<RowMapper<T>> specialize0(StatementContext ctx, List<String> columnNames, List<ColumnNameMatcher> columnNameMatchers, List<String> unmatchedColumns) {
        int count = this.factory.getParameterCount();
        Parameter[] parameters = this.factory.getParameters();
        boolean matchedColumns = false;
        ArrayList<String> unmatchedParameters = new ArrayList<String>();
        ArrayList<ParameterData> paramData = new ArrayList<ParameterData>();
        for (int i = 0; i < count; ++i) {
            Parameter parameter = parameters[i];
            boolean nullable = this.isNullable(parameter);
            Nested anno = parameter.getAnnotation(Nested.class);
            if (anno == null) {
                String paramName = this.prefix + ConstructorMapper.paramName(parameters, i, this.constructorProperties);
                OptionalInt columnIndex = ReflectionMapperUtil.findColumnIndex(paramName, columnNames, columnNameMatchers, () -> this.debugName(parameter));
                if (columnIndex.isPresent()) {
                    int colIndex = columnIndex.getAsInt();
                    QualifiedType<?> type = QualifiedType.of(parameter.getParameterizedType()).withAnnotations(ctx.getConfig(Qualifiers.class).findFor(parameter));
                    paramData.add(new ParameterData(i, parameter, ctx.findColumnMapperFor(type).map(mapper -> new SingleColumnMapper(mapper, colIndex + 1)).orElseThrow(() -> new IllegalArgumentException(String.format(MISSING_COLUMN_MAPPER, type, paramName, this.factory)))));
                    matchedColumns = true;
                    unmatchedColumns.remove(columnNames.get(colIndex));
                    continue;
                }
                if (nullable) {
                    paramData.add(new ParameterData(i, parameter, (r, c) -> null));
                    continue;
                }
                unmatchedParameters.add(paramName);
                continue;
            }
            String nestedPrefix = this.prefix + anno.value();
            Optional<RowMapper<T>> nestedMapper = this.nestedMappers.computeIfAbsent(parameter, p -> new ConstructorMapper(JdbiConstructors.findFactoryFor(p.getType()), nestedPrefix)).specialize0(ctx, columnNames, columnNameMatchers, unmatchedColumns);
            if (nestedMapper.isPresent()) {
                paramData.add(new ParameterData(i, parameter, nestedMapper.get()));
                matchedColumns = true;
                continue;
            }
            if (nullable) {
                paramData.add(new ParameterData(i, parameter, (r, c) -> null));
                continue;
            }
            unmatchedParameters.add(ConstructorMapper.paramName(parameters, i, this.constructorProperties));
        }
        if (!matchedColumns) {
            return Optional.empty();
        }
        Collections.sort(paramData, Comparator.comparing(p -> p.propagateNull ? 1 : 0));
        if (!unmatchedParameters.isEmpty()) {
            throw new IllegalArgumentException(String.format(UNMATCHED_CONSTRUCTOR_PARAMETER, this.factory, unmatchedParameters));
        }
        Optional<String> nullMarkerColumn = Optional.ofNullable(this.factory.getAnnotationIncludingType(PropagateNull.class)).map(PropagateNull::value);
        return Optional.of((r, c) -> {
            if (PojoMapper.propagateNull(r, nullMarkerColumn)) {
                return null;
            }
            Object[] params = new Object[count];
            for (ParameterData p : paramData) {
                params[p.index] = p.mapper.map(r, c);
                if (!p.propagateNull || params[p.index] != null && (!p.isPrimitive || !r.wasNull())) continue;
                return null;
            }
            return this.factory.newInstance(params);
        });
    }

    private boolean isNullable(Parameter parameter) {
        return Stream.of(parameter.getAnnotations()).map(Annotation::annotationType).map(Class::getSimpleName).anyMatch("Nullable"::equals);
    }

    private static String paramName(Parameter[] parameters, int position, ConstructorProperties parameterNames) {
        Parameter parameter = parameters[position];
        ColumnName dbName = parameter.getAnnotation(ColumnName.class);
        if (dbName != null) {
            return dbName.value();
        }
        if (parameterNames != null) {
            return parameterNames.value()[position];
        }
        return parameter.getName();
    }

    private String debugName(Parameter parameter) {
        return String.format("%s constructor parameter %s", this.factory.getDeclaringClass().getSimpleName(), parameter.getName());
    }

    static class UnmatchedConstructorMapper<T>
    implements RowMapper<T> {
        private final String message;

        UnmatchedConstructorMapper(String message) {
            this.message = message;
        }

        @Override
        public T map(ResultSet rs, StatementContext ctx) throws SQLException {
            throw new IllegalArgumentException(this.message);
        }
    }

    private static class ParameterData {
        final int index;
        final Parameter parameter;
        final RowMapper<?> mapper;
        final boolean propagateNull;
        final boolean isPrimitive;

        ParameterData(int index, Parameter parameter, RowMapper<?> mapper) {
            this.index = index;
            this.parameter = parameter;
            this.mapper = mapper;
            this.propagateNull = parameter.getAnnotation(PropagateNull.class) != null;
            this.isPrimitive = parameter.getType().isPrimitive();
        }
    }
}

