/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.core.internal.exceptions;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.reflect.InvocationTargetException;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import org.jdbi.v3.core.internal.UtilityClassException;
import org.jdbi.v3.core.internal.exceptions.DummyException;

public class Sneaky {
    private Sneaky() {
        throw new UtilityClassException();
    }

    @CheckReturnValue
    @Nonnull
    public static DummyException throwAnyway(Throwable t) {
        if (t instanceof Error) {
            throw (Error)t;
        }
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        if (t instanceof IOException) {
            throw new UncheckedIOException((IOException)t);
        }
        if (t instanceof InterruptedException) {
            Thread.currentThread().interrupt();
        }
        if (t instanceof InvocationTargetException) {
            throw Sneaky.throwAnyway(t.getCause());
        }
        Sneaky.throwEvadingChecks(t);
        return null;
    }

    private static <E extends Throwable> void throwEvadingChecks(Throwable throwable) throws E {
        throw throwable;
    }
}

