/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.core.transaction;

import java.sql.SQLException;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.HandleCallback;
import org.jdbi.v3.core.config.JdbiConfig;
import org.jdbi.v3.core.transaction.DelegatingTransactionHandler;
import org.jdbi.v3.core.transaction.LocalTransactionHandler;
import org.jdbi.v3.core.transaction.TransactionHandler;
import org.jdbi.v3.core.transaction.TransactionIsolationLevel;

public class SerializableTransactionRunner
extends DelegatingTransactionHandler
implements TransactionHandler {
    private static final String SQLSTATE_TXN_SERIALIZATION_FAILED = "40001";

    public SerializableTransactionRunner() {
        this(new LocalTransactionHandler());
    }

    public SerializableTransactionRunner(TransactionHandler delegate) {
        super(delegate);
    }

    @Override
    public <R, X extends Exception> R inTransaction(Handle handle, HandleCallback<R, X> callback) throws X {
        Configuration config = handle.getConfig(Configuration.class);
        int attempts = 1 + config.maxRetries;
        Exception stack = null;
        while (true) {
            try {
                return this.getDelegate().inTransaction(handle, callback);
            }
            catch (Exception last) {
                Exception x = last;
                if (!this.isSqlState(config.serializationFailureSqlState, x)) {
                    throw last;
                }
                if (stack == null) {
                    stack = x;
                    continue;
                }
                stack.addSuppressed(last);
                if (--attempts > 0) continue;
                throw stack;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <R, X extends Exception> R inTransaction(Handle handle, TransactionIsolationLevel level, HandleCallback<R, X> callback) throws X {
        TransactionIsolationLevel initial = handle.getTransactionIsolationLevel();
        try {
            handle.setTransactionIsolation(level);
            R r = this.inTransaction(handle, callback);
            return r;
        }
        finally {
            handle.setTransactionIsolation(initial);
        }
    }

    protected boolean isSqlState(String expectedSqlState, Throwable throwable) {
        Throwable t = throwable;
        do {
            String sqlState;
            if (!(t instanceof SQLException) || (sqlState = ((SQLException)t).getSQLState()) == null || !sqlState.startsWith(expectedSqlState)) continue;
            return true;
        } while ((t = t.getCause()) != null);
        return false;
    }

    public static class Configuration
    implements JdbiConfig<Configuration> {
        private static final int DEFAULT_MAX_RETRIES = 5;
        private int maxRetries = 5;
        private String serializationFailureSqlState = "40001";

        public Configuration setMaxRetries(int maxRetries) {
            if (maxRetries < 0) {
                throw new IllegalArgumentException("\"" + maxRetries + " retries\" makes no sense. Set a number >= 0 (default " + 5 + ").");
            }
            this.maxRetries = maxRetries;
            return this;
        }

        public Configuration setSerializationFailureSqlState(String serializationFailureSqlState) {
            this.serializationFailureSqlState = serializationFailureSqlState;
            return this;
        }

        @Override
        public Configuration createCopy() {
            return new Configuration().setMaxRetries(this.maxRetries).setSerializationFailureSqlState(this.serializationFailureSqlState);
        }
    }
}

