/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.core.mapper.reflect;

import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.jdbi.v3.core.mapper.ColumnMapper;
import org.jdbi.v3.core.mapper.Nested;
import org.jdbi.v3.core.mapper.RowMapper;
import org.jdbi.v3.core.mapper.RowMapperFactory;
import org.jdbi.v3.core.mapper.SingleColumnMapper;
import org.jdbi.v3.core.mapper.reflect.ColumnName;
import org.jdbi.v3.core.mapper.reflect.ColumnNameMatcher;
import org.jdbi.v3.core.mapper.reflect.ReflectionMapperUtil;
import org.jdbi.v3.core.mapper.reflect.ReflectionMappers;
import org.jdbi.v3.core.statement.StatementContext;

public class FieldMapper<T>
implements RowMapper<T> {
    static final String DEFAULT_PREFIX = "";
    private final Class<T> type;
    private final String prefix;
    private final Map<Field, FieldMapper<?>> nestedMappers = new ConcurrentHashMap();

    public static RowMapperFactory factory(Class<?> type) {
        return RowMapperFactory.of(type, FieldMapper.of(type));
    }

    public static RowMapperFactory factory(Class<?> type, String prefix) {
        return RowMapperFactory.of(type, FieldMapper.of(type, prefix));
    }

    public static <T> RowMapper<T> of(Class<T> type) {
        return FieldMapper.of(type, DEFAULT_PREFIX);
    }

    public static <T> RowMapper<T> of(Class<T> type, String prefix) {
        return new FieldMapper<T>(type, prefix);
    }

    private FieldMapper(Class<T> type, String prefix) {
        this.type = type;
        this.prefix = prefix.toLowerCase();
    }

    @Override
    public T map(ResultSet rs, StatementContext ctx) throws SQLException {
        return this.specialize(rs, ctx).map(rs, ctx);
    }

    @Override
    public RowMapper<T> specialize(ResultSet rs, StatementContext ctx) throws SQLException {
        List<String> columnNames = ReflectionMapperUtil.getColumnNames(rs);
        List<ColumnNameMatcher> columnNameMatchers = ctx.getConfig(ReflectionMappers.class).getColumnNameMatchers();
        ArrayList<String> unmatchedColumns = new ArrayList<String>(columnNames);
        RowMapper<T> mapper = this.specialize0(rs, ctx, columnNames, columnNameMatchers, unmatchedColumns);
        if (ctx.getConfig(ReflectionMappers.class).isStrictMatching() && unmatchedColumns.stream().anyMatch(col -> col.startsWith(this.prefix))) {
            throw new IllegalArgumentException(String.format("Mapping type %s could not match fields for columns: %s", this.type.getSimpleName(), unmatchedColumns));
        }
        return mapper;
    }

    private RowMapper<T> specialize0(ResultSet rs, StatementContext ctx, List<String> columnNames, List<ColumnNameMatcher> columnNameMatchers, List<String> unmatchedColumns) throws SQLException {
        ArrayList mappers = new ArrayList();
        ArrayList<Field> fields = new ArrayList<Field>();
        for (Class<T> aType = this.type; aType != null; aType = aType.getSuperclass()) {
            for (Field field : aType.getDeclaredFields()) {
                Nested anno = field.getAnnotation(Nested.class);
                if (anno == null) {
                    String paramName = this.prefix + FieldMapper.paramName(field);
                    ReflectionMapperUtil.findColumnIndex(paramName, columnNames, columnNameMatchers, () -> this.debugName(field)).ifPresent(index -> {
                        Type type = field.getGenericType();
                        ColumnMapper<Object> mapper = ctx.findColumnMapperFor(type).orElse((r, n, c) -> rs.getObject(n));
                        mappers.add(new SingleColumnMapper<Object>(mapper, index + 1));
                        fields.add(field);
                        unmatchedColumns.remove(columnNames.get(index));
                    });
                    continue;
                }
                String nestedPrefix = this.prefix + anno.value().toLowerCase();
                RowMapper<T> mapper = this.nestedMappers.computeIfAbsent(field, f -> new FieldMapper(field.getType(), nestedPrefix)).specialize0(rs, ctx, columnNames, columnNameMatchers, unmatchedColumns);
                mappers.add(mapper);
                fields.add(field);
            }
        }
        if (mappers.isEmpty() && columnNames.size() > 0) {
            throw new IllegalArgumentException(String.format("Mapping fields for type %s didn't find any matching columns in result set", this.type));
        }
        return (r, c) -> {
            T obj = this.construct();
            for (int i = 0; i < mappers.size(); ++i) {
                RowMapper mapper = (RowMapper)mappers.get(i);
                Field field = (Field)fields.get(i);
                Object value = mapper.map(rs, ctx);
                this.writeField(obj, field, value);
            }
            return obj;
        };
    }

    private static String paramName(Field field) {
        return Optional.ofNullable(field.getAnnotation(ColumnName.class)).map(ColumnName::value).orElseGet(field::getName);
    }

    private String debugName(Field field) {
        return String.format("%s.%s", this.type.getSimpleName(), field.getName());
    }

    private T construct() {
        try {
            return this.type.newInstance();
        }
        catch (Exception e) {
            String message = String.format("A type, %s, was mapped which was not instantiable", this.type.getName());
            throw new IllegalArgumentException(message, e);
        }
    }

    private void writeField(T obj, Field field, Object value) {
        try {
            field.setAccessible(true);
            field.set(obj, value);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException(String.format("Unable to access property, %s", field.getName()), e);
        }
    }
}

