/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.core.mapper.reflect;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jdbi.v3.core.config.JdbiConfig;
import org.jdbi.v3.core.mapper.reflect.CaseInsensitiveColumnNameMatcher;
import org.jdbi.v3.core.mapper.reflect.ColumnNameMatcher;
import org.jdbi.v3.core.mapper.reflect.SnakeCaseColumnNameMatcher;

public class ReflectionMappers
implements JdbiConfig<ReflectionMappers> {
    private List<ColumnNameMatcher> columnNameMatchers;
    private boolean strictMatching;

    public ReflectionMappers() {
        this.columnNameMatchers = Arrays.asList(new CaseInsensitiveColumnNameMatcher(), new SnakeCaseColumnNameMatcher());
        this.strictMatching = false;
    }

    private ReflectionMappers(ReflectionMappers that) {
        this.columnNameMatchers = new ArrayList<ColumnNameMatcher>(that.columnNameMatchers);
        this.strictMatching = that.strictMatching;
    }

    public List<ColumnNameMatcher> getColumnNameMatchers() {
        return Collections.unmodifiableList(this.columnNameMatchers);
    }

    public ReflectionMappers setColumnNameMatchers(List<ColumnNameMatcher> columnNameMatchers) {
        this.columnNameMatchers = new ArrayList<ColumnNameMatcher>(columnNameMatchers);
        return this;
    }

    public boolean isStrictMatching() {
        return this.strictMatching;
    }

    public ReflectionMappers setStrictMatching(boolean strictMatching) {
        this.strictMatching = strictMatching;
        return this;
    }

    @Override
    public ReflectionMappers createCopy() {
        return new ReflectionMappers(this);
    }
}

