/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.core.mapper;

import java.lang.reflect.Type;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Optional;
import org.jdbi.v3.core.config.ConfigRegistry;
import org.jdbi.v3.core.generic.GenericTypes;
import org.jdbi.v3.core.mapper.ColumnGetter;
import org.jdbi.v3.core.mapper.ColumnMapper;
import org.jdbi.v3.core.mapper.ColumnMapperFactory;
import org.jdbi.v3.core.mapper.ColumnMappers;
import org.jdbi.v3.core.result.UnableToProduceResultException;

class PrimitiveMapperFactory
implements ColumnMapperFactory {
    private final Map<Class<?>, ColumnMapper<?>> mappers = new IdentityHashMap();

    PrimitiveMapperFactory() {
        this.mappers.put(Boolean.TYPE, PrimitiveMapperFactory.primitiveMapper(ResultSet::getBoolean));
        this.mappers.put(Byte.TYPE, PrimitiveMapperFactory.primitiveMapper(ResultSet::getByte));
        this.mappers.put(Character.TYPE, PrimitiveMapperFactory.primitiveMapper(PrimitiveMapperFactory::getChar));
        this.mappers.put(Short.TYPE, PrimitiveMapperFactory.primitiveMapper(ResultSet::getShort));
        this.mappers.put(Integer.TYPE, PrimitiveMapperFactory.primitiveMapper(ResultSet::getInt));
        this.mappers.put(Long.TYPE, PrimitiveMapperFactory.primitiveMapper(ResultSet::getLong));
        this.mappers.put(Float.TYPE, PrimitiveMapperFactory.primitiveMapper(ResultSet::getFloat));
        this.mappers.put(Double.TYPE, PrimitiveMapperFactory.primitiveMapper(ResultSet::getDouble));
    }

    @Override
    public Optional<ColumnMapper<?>> build(Type type, ConfigRegistry config) {
        Class<?> rawType = GenericTypes.getErasedType(type);
        return Optional.ofNullable(this.mappers.get(rawType));
    }

    private static <T> ColumnMapper<T> primitiveMapper(ColumnGetter<T> getter) {
        return (r, i, ctx) -> {
            Object value = getter.get(r, i);
            if (r.wasNull() && !ctx.getConfig(ColumnMappers.class).getCoalesceNullPrimitivesToDefaults()) {
                String msg = String.format("Database null values are not allowed for Java primitives by the current configuration: could not map column %s (%s). Change your result type to a boxed primitive to resolve.", i, r.getMetaData().getColumnLabel(i));
                throw new UnableToProduceResultException(msg);
            }
            return value;
        };
    }

    private static char getChar(ResultSet r, int i) throws SQLException {
        Character character = PrimitiveMapperFactory.getCharacter(r, i);
        return character == null ? (char)'\u0000' : character.charValue();
    }

    private static Character getCharacter(ResultSet r, int i) throws SQLException {
        String s = r.getString(i);
        if (s != null && !s.isEmpty()) {
            return Character.valueOf(s.charAt(0));
        }
        return null;
    }
}

