/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.core.mapper.reflect.internal;

import io.leangen.geantyref.GenericTypeReflector;
import java.lang.annotation.Annotation;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.jdbi.v3.core.config.ConfigRegistry;
import org.jdbi.v3.core.internal.exceptions.CheckedBiFunction;
import org.jdbi.v3.core.internal.exceptions.CheckedFunction;
import org.jdbi.v3.core.internal.exceptions.Unchecked;
import org.jdbi.v3.core.mapper.reflect.internal.BuilderSpec;
import org.jdbi.v3.core.mapper.reflect.internal.PojoBuilderUtils;
import org.jdbi.v3.core.mapper.reflect.internal.PojoProperties;
import org.jdbi.v3.core.qualifier.QualifiedType;
import org.jdbi.v3.core.qualifier.Qualifiers;

public class BuilderPojoProperties<T, B>
extends PojoProperties<T> {
    protected MethodHandle builderBuild;
    private final Map<String, BuilderPojoProperty<T>> properties;
    protected final ConfigRegistry config;
    protected final Class<T> defn;
    protected final Class<?> impl;
    protected final Supplier<?> builder;

    BuilderPojoProperties(Type type, ConfigRegistry config, Class<T> defn, Class<?> impl, Supplier<B> builder) {
        super(type);
        this.config = config;
        this.defn = defn;
        this.impl = impl;
        this.builder = builder;
        this.properties = Arrays.stream(defn.getMethods()).filter(PojoBuilderUtils::isProperty).map(p -> this.createProperty(PojoBuilderUtils.propertyName(p), (Method)p)).collect(Collectors.toMap(PojoProperties.PojoProperty::getName, Function.identity()));
    }

    BuilderPojoProperties(BuilderSpec<T, B> spec) {
        this(spec.type, spec.config, spec.defn, null, spec.builder);
        try {
            this.builderBuild = MethodHandles.lookup().unreflect(this.builder.get().getClass().getMethod("build", new Class[0]));
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new IllegalArgumentException("Failed to inspect Immutables " + this.defn, e);
        }
    }

    @Override
    public Map<String, BuilderPojoProperty<T>> getProperties() {
        return this.properties;
    }

    protected BuilderPojoProperty<T> createProperty(String name, Method m) {
        Class<?> builderClass = this.builder.get().getClass();
        try {
            Type propertyType = GenericTypeReflector.getExactReturnType((Method)m, (Type)this.getType());
            return new BuilderPojoProperty(name, QualifiedType.of(propertyType).withAnnotations(this.config.get(Qualifiers.class).findFor(m)), m, PojoBuilderUtils.alwaysSet(), MethodHandles.lookup().unreflect(m).asFixedArity(), PojoBuilderUtils.findBuilderSetter(builderClass, name, m, propertyType).asFixedArity());
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Failed to inspect method " + m, e);
        }
    }

    @Override
    public PojoProperties.PojoBuilder<T> create() {
        final Object b = this.builder.get();
        return new PojoProperties.PojoBuilder<T>(){

            @Override
            public void set(String property, Object value) {
                Unchecked.biFunction((CheckedBiFunction<Object, Object, Object>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, invoke(java.lang.Object java.lang.Object ), (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;)((MethodHandle)BuilderPojoProperties.this.getProperties().get((Object)property).setter)).apply(b, value);
            }

            @Override
            public T build() {
                return BuilderPojoProperties.this.defn.cast(Unchecked.function((CheckedFunction<Object, Object>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, invoke(java.lang.Object ), (Ljava/lang/Object;)Ljava/lang/Object;)((MethodHandle)BuilderPojoProperties.this.builderBuild)).apply(b));
            }
        };
    }

    public static class BuilderPojoProperty<T>
    implements PojoProperties.PojoProperty<T> {
        private final String name;
        private final QualifiedType<?> type;
        private final Method defn;
        private final MethodHandle isSet;
        private final MethodHandle getter;
        final MethodHandle setter;

        BuilderPojoProperty(String name, QualifiedType<?> type, Method defn, MethodHandle isSet, MethodHandle getter, MethodHandle setter) {
            this.name = name;
            this.type = type;
            this.defn = defn;
            this.isSet = isSet;
            this.getter = getter;
            this.setter = setter;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public QualifiedType<?> getQualifiedType() {
            return this.type;
        }

        @Override
        public <A extends Annotation> Optional<A> getAnnotation(Class<A> anno) {
            return Optional.ofNullable(this.defn.getAnnotation(anno));
        }

        @Override
        public Object get(T pojo) {
            return Unchecked.callable(() -> {
                if (Boolean.TRUE.equals(this.isSet.invoke(pojo))) {
                    return this.getter.invoke(pojo);
                }
                return null;
            }).call();
        }
    }
}

