/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.core.config;

import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.jdbi.v3.core.argument.Arguments;
import org.jdbi.v3.core.config.JdbiCaches;
import org.jdbi.v3.core.config.JdbiConfig;
import org.jdbi.v3.core.mapper.ColumnMappers;
import org.jdbi.v3.core.mapper.RowMappers;
import org.jdbi.v3.core.statement.SqlStatements;

public final class ConfigRegistry {
    private final Object createLock = new Object();
    private final Map<Class<? extends JdbiConfig<?>>, JdbiConfig<?>> configs = new ConcurrentHashMap();

    public ConfigRegistry() {
        this.get(JdbiCaches.class);
        this.get(SqlStatements.class);
        this.get(Arguments.class);
        this.get(RowMappers.class);
        this.get(ColumnMappers.class);
    }

    private ConfigRegistry(ConfigRegistry that) {
        that.configs.forEach((type, config) -> {
            Object copy = config.createCopy();
            this.configs.put((Class<JdbiConfig<?>>)type, (JdbiConfig<?>)copy);
        });
        this.configs.values().forEach(c -> c.setRegistry(this));
    }

    public <C extends JdbiConfig<C>> C get(Class<C> configClass) {
        JdbiConfig<?> lookup = this.configs.get(configClass);
        if (lookup != null) {
            return (C)((JdbiConfig)configClass.cast(lookup));
        }
        Object object = this.createLock;
        synchronized (object) {
            try {
                JdbiConfig config;
                try {
                    config = (JdbiConfig)configClass.getDeclaredConstructor(ConfigRegistry.class).newInstance(this);
                }
                catch (NoSuchMethodException e) {
                    config = (JdbiConfig)configClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    config.setRegistry(this);
                }
                return (C)Optional.ofNullable(configClass.cast(this.configs.putIfAbsent(configClass, config))).orElse(config);
            }
            catch (ReflectiveOperationException e) {
                throw new IllegalStateException("Unable to instantiate config class " + configClass + ". Is there a public no-arg constructor?", e);
            }
        }
    }

    public ConfigRegistry createCopy() {
        return new ConfigRegistry(this);
    }
}

