/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.core.mapper.reflect.internal;

import io.leangen.geantyref.GenericTypeReflector;
import java.lang.annotation.Annotation;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.jdbi.v3.core.config.ConfigRegistry;
import org.jdbi.v3.core.config.JdbiCache;
import org.jdbi.v3.core.config.JdbiCaches;
import org.jdbi.v3.core.generic.GenericTypes;
import org.jdbi.v3.core.internal.exceptions.CheckedBiFunction;
import org.jdbi.v3.core.internal.exceptions.CheckedFunction;
import org.jdbi.v3.core.internal.exceptions.Unchecked;
import org.jdbi.v3.core.mapper.reflect.ColumnName;
import org.jdbi.v3.core.mapper.reflect.internal.PojoProperties;
import org.jdbi.v3.core.qualifier.QualifiedType;
import org.jdbi.v3.core.qualifier.Qualifiers;

public interface ImmutablesPropertiesFactory {
    public static final JdbiCache<ImmutableSpec<?, ?>, ImmutablePojoProperties<?, ?>> IMMUTABLE_CACHE = JdbiCaches.declare(s -> s.type, ImmutablePojoProperties::new);
    public static final JdbiCache<ModifiableSpec<?, ?>, ModifiablePojoProperties<?, ?>> MODIFIABLE_CACHE = JdbiCaches.declare(s -> s.type, ModifiablePojoProperties::new);

    public PojoProperties<?> create(Type var1, ConfigRegistry var2);

    public static <T, B> ImmutablesPropertiesFactory immutable(Class<T> defn, Supplier<B> builder) {
        return (t, config) -> IMMUTABLE_CACHE.get(new ImmutableSpec(t, config, defn, builder), config);
    }

    public static <T, M extends T> ImmutablesPropertiesFactory modifiable(Class<T> defn, Class<M> impl, Supplier<M> constructor) {
        return (t, config) -> MODIFIABLE_CACHE.get(new ModifiableSpec(t, config, defn, impl, constructor), config);
    }

    public static MethodHandle alwaysSet() {
        return MethodHandles.dropArguments(MethodHandles.constant(Boolean.TYPE, true), 0, new Class[]{Object.class});
    }

    public static class ModifiableSpec<T, M> {
        Type type;
        ConfigRegistry config;
        Class<T> defn;
        Class<M> impl;
        Supplier<M> constructor;

        ModifiableSpec(Type type, ConfigRegistry config, Class<T> defn, Class<M> impl, Supplier<M> constructor) {
            this.type = type;
            this.config = config;
            this.defn = defn;
            this.impl = impl;
            this.constructor = constructor;
        }
    }

    public static class ImmutableSpec<T, B> {
        Type type;
        ConfigRegistry config;
        Class<T> defn;
        Supplier<B> builder;

        ImmutableSpec(Type type, ConfigRegistry config, Class<T> defn, Supplier<B> builder) {
            this.type = type;
            this.config = config;
            this.defn = defn;
            this.builder = builder;
        }
    }

    public static class ImmutablesPojoProperty<T>
    implements PojoProperties.PojoProperty<T> {
        private final String name;
        private final QualifiedType<?> type;
        private final Method defn;
        private final MethodHandle isSet;
        private final MethodHandle getter;
        final MethodHandle setter;

        ImmutablesPojoProperty(String name, QualifiedType<?> type, Method defn, MethodHandle isSet, MethodHandle getter, MethodHandle setter) {
            this.name = name;
            this.type = type;
            this.defn = defn;
            this.isSet = isSet;
            this.getter = getter;
            this.setter = setter;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public QualifiedType<?> getQualifiedType() {
            return this.type;
        }

        @Override
        public <A extends Annotation> Optional<A> getAnnotation(Class<A> anno) {
            return Optional.ofNullable(this.defn.getAnnotation(anno));
        }

        @Override
        public Object get(T pojo) {
            return Unchecked.callable(() -> {
                if (Boolean.TRUE.equals(this.isSet.invoke(pojo))) {
                    return this.getter.invoke(pojo);
                }
                return null;
            }).call();
        }
    }

    public static class ModifiablePojoProperties<T, M>
    extends BasePojoProperties<T, M> {
        ModifiablePojoProperties(ModifiableSpec<T, M> spec) {
            super(spec.type, spec.config, spec.defn, spec.impl, spec.constructor);
        }

        @Override
        protected ImmutablesPojoProperty<T> createProperty(String name, Method m) {
            Type propertyType = GenericTypes.resolveType(m.getGenericReturnType(), this.getType());
            try {
                return new ImmutablesPojoProperty(name, QualifiedType.of(propertyType).withAnnotations(this.config.get(Qualifiers.class).findFor(m)), m, this.isSetMethod(name), MethodHandles.lookup().unreflect(m).asFixedArity(), MethodHandles.lookup().findVirtual(this.impl, this.setterName(name), MethodType.methodType(this.impl, GenericTypes.getErasedType(propertyType))).asFixedArity());
            }
            catch (IllegalAccessException | NoSuchMethodException e) {
                throw new IllegalArgumentException("Failed to inspect method " + m, e);
            }
        }

        private MethodHandle isSetMethod(String name) {
            try {
                return MethodHandles.lookup().findVirtual(this.impl, name + "IsSet", MethodType.methodType(Boolean.TYPE));
            }
            catch (NoSuchMethodException e) {
                return ImmutablesPropertiesFactory.alwaysSet();
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException("Failed to find IsSet method for " + name, e);
            }
        }

        private String setterName(String name) {
            return "set" + name.substring(0, 1).toUpperCase() + name.substring(1);
        }

        @Override
        public PojoProperties.PojoBuilder<T> create() {
            final Object instance = this.builder.get();
            return new PojoProperties.PojoBuilder<T>(){

                @Override
                public void set(String property, Object value) {
                    Unchecked.biFunction((CheckedBiFunction<Object, Object, Object>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, invoke(java.lang.Object java.lang.Object ), (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;)((MethodHandle)this.getProperties().get((Object)property).setter)).apply(instance, value);
                }

                @Override
                public T build() {
                    return instance;
                }
            };
        }
    }

    public static class ImmutablePojoProperties<T, B>
    extends BasePojoProperties<T, B> {
        private MethodHandle builderBuild;

        ImmutablePojoProperties(ImmutableSpec<T, B> spec) {
            super(spec.type, spec.config, spec.defn, null, spec.builder);
            try {
                this.builderBuild = MethodHandles.lookup().unreflect(this.builder.get().getClass().getMethod("build", new Class[0]));
            }
            catch (IllegalAccessException | NoSuchMethodException e) {
                throw new IllegalArgumentException("Failed to inspect Immutables " + this.defn, e);
            }
        }

        @Override
        protected ImmutablesPojoProperty<T> createProperty(String name, Method m) {
            Class<?> builderClass = this.builder.get().getClass();
            try {
                Type propertyType = GenericTypeReflector.getExactReturnType((Method)m, (Type)this.getType());
                return new ImmutablesPojoProperty(name, QualifiedType.of(propertyType).withAnnotations(this.config.get(Qualifiers.class).findFor(m)), m, ImmutablesPropertiesFactory.alwaysSet(), MethodHandles.lookup().unreflect(m).asFixedArity(), this.findBuilderSetter(builderClass, name, m, propertyType).asFixedArity());
            }
            catch (IllegalAccessException | NoSuchMethodException e) {
                throw new IllegalArgumentException("Failed to inspect method " + m, e);
            }
        }

        private MethodHandle findBuilderSetter(Class<?> builderClass, String name, Method decl, Type type) throws IllegalAccessException, NoSuchMethodException {
            ArrayList<NoSuchMethodException> failures = new ArrayList<NoSuchMethodException>();
            LinkedHashSet<String> names = new LinkedHashSet<String>();
            names.add(decl.getName());
            names.add(name);
            if (name.length() > 1) {
                String string = name.substring(0, 1).toUpperCase() + name.substring(1);
                names.add("set" + string);
                names.add("is" + string);
            }
            for (String tryName : names) {
                try {
                    return MethodHandles.lookup().unreflect(builderClass.getMethod(tryName, GenericTypes.getErasedType(type)));
                }
                catch (NoSuchMethodException e) {
                    failures.add(e);
                }
            }
            for (Method m : builderClass.getMethods()) {
                if (!names.contains(m.getName()) || m.getParameterCount() != 1) continue;
                return MethodHandles.lookup().unreflect(m);
            }
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Failed to find builder setter for property " + name + " on " + builderClass);
            failures.forEach(illegalArgumentException::addSuppressed);
            return MethodHandles.dropArguments(MethodHandles.throwException(Object.class, IllegalArgumentException.class), 1, Arrays.asList(Object.class, Object.class)).bindTo(illegalArgumentException);
        }

        @Override
        public PojoProperties.PojoBuilder<T> create() {
            final Object b = this.builder.get();
            return new PojoProperties.PojoBuilder<T>(){

                @Override
                public void set(String property, Object value) {
                    Unchecked.biFunction((CheckedBiFunction<Object, Object, Object>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, invoke(java.lang.Object java.lang.Object ), (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;)((MethodHandle)this.getProperties().get((Object)property).setter)).apply(b, value);
                }

                @Override
                public T build() {
                    return defn.cast(Unchecked.function((CheckedFunction<Object, Object>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, invoke(java.lang.Object ), (Ljava/lang/Object;)Ljava/lang/Object;)((MethodHandle)builderBuild)).apply(b));
                }
            };
        }
    }

    public static abstract class BasePojoProperties<T, B>
    extends PojoProperties<T> {
        private final Map<String, ImmutablesPojoProperty<T>> properties;
        protected final ConfigRegistry config;
        protected final Class<T> defn;
        protected final Class<?> impl;
        protected final Supplier<?> builder;

        BasePojoProperties(Type type, ConfigRegistry config, Class<T> defn, Class<?> impl, Supplier<B> builder) {
            super(type);
            this.config = config;
            this.defn = defn;
            this.impl = impl;
            this.builder = builder;
            this.properties = Arrays.stream(defn.getMethods()).filter(BasePojoProperties::isProperty).map(p -> this.createProperty(BasePojoProperties.propertyName(p), (Method)p)).collect(Collectors.toMap(PojoProperties.PojoProperty::getName, Function.identity()));
        }

        static String propertyName(Method m) {
            String[] prefixes = new String[]{"get", "is"};
            ColumnName colName = m.getAnnotation(ColumnName.class);
            if (colName != null) {
                return colName.value();
            }
            String name = m.getName();
            for (String prefix : prefixes) {
                if (!name.startsWith(prefix) || name.length() <= prefix.length() || !Character.isUpperCase(name.charAt(prefix.length()))) continue;
                return BasePojoProperties.chopPrefix(name, prefix.length());
            }
            return name;
        }

        private static String chopPrefix(String name, int off) {
            return name.substring(off, off + 1).toLowerCase() + name.substring(off + 1);
        }

        private static boolean isProperty(Method m) {
            return m.getParameterCount() == 0 && !m.isSynthetic() && !Modifier.isStatic(m.getModifiers()) && m.getDeclaringClass() != Object.class;
        }

        @Override
        public Map<String, ImmutablesPojoProperty<T>> getProperties() {
            return this.properties;
        }

        abstract ImmutablesPojoProperty<T> createProperty(String var1, Method var2);
    }
}

