/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.core.statement;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.result.ResultBearing;
import org.jdbi.v3.core.result.ResultIterator;
import org.jdbi.v3.core.result.ResultProducer;
import org.jdbi.v3.core.result.ResultProducers;
import org.jdbi.v3.core.result.ResultSetScanner;
import org.jdbi.v3.core.result.UnableToProduceResultException;
import org.jdbi.v3.core.statement.ArgumentBinder;
import org.jdbi.v3.core.statement.Batch;
import org.jdbi.v3.core.statement.Binding;
import org.jdbi.v3.core.statement.ParsedParameters;
import org.jdbi.v3.core.statement.ParsedSql;
import org.jdbi.v3.core.statement.SqlStatement;
import org.jdbi.v3.core.statement.SqlStatements;
import org.jdbi.v3.core.statement.StatementBuilder;
import org.jdbi.v3.core.statement.StatementContext;
import org.jdbi.v3.core.statement.UnableToCreateStatementException;
import org.jdbi.v3.core.statement.UnableToExecuteStatementException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PreparedBatch
extends SqlStatement<PreparedBatch>
implements ResultBearing {
    private static final Logger LOG = LoggerFactory.getLogger(PreparedBatch.class);
    private final List<Binding> bindings = new ArrayList<Binding>();

    public PreparedBatch(Handle handle, String sql) {
        super(handle, sql);
    }

    @Override
    public <R> R scanResultSet(ResultSetScanner<R> mapper) {
        return this.execute(ResultProducers.returningResults()).scanResultSet(mapper);
    }

    public int[] execute() {
        return this.internalBatchExecute().updateCounts;
    }

    public ResultIterator<Integer> executeAndGetModCount() {
        final StatementContext ctx = this.getContext();
        final int[] modCount = this.execute();
        return new ResultIterator<Integer>(){
            int pos = 0;

            @Override
            public boolean hasNext() {
                return this.pos < modCount.length;
            }

            @Override
            public Integer next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return modCount[this.pos++];
            }

            @Override
            public StatementContext getContext() {
                return ctx;
            }

            @Override
            public void close() {
            }
        };
    }

    public ResultBearing executeAndReturnGeneratedKeys(String ... columnNames) {
        return this.execute(ResultProducers.returningGeneratedKeys(columnNames));
    }

    public <R> R execute(ResultProducer<R> producer) {
        try {
            return producer.produce(() -> this.internalBatchExecute().stmt, this.getContext());
        }
        catch (SQLException e) {
            try {
                this.close();
            }
            catch (Exception e1) {
                e.addSuppressed(e1);
            }
            throw new UnableToProduceResultException("Exception producing batch result", e, this.getContext());
        }
    }

    private ExecutedBatch internalBatchExecute() {
        if (!this.getBinding().isEmpty()) {
            this.add();
        }
        if (this.bindings.isEmpty()) {
            throw new IllegalStateException("No batch parts to execute");
        }
        String renderedSql = this.getConfig(SqlStatements.class).getTemplateEngine().render(this.getSql(), this.getContext());
        this.getContext().setRenderedSql(renderedSql);
        ParsedSql parsedSql = this.getConfig(SqlStatements.class).getSqlParser().parse(renderedSql, this.getContext());
        String sql = parsedSql.getSql();
        ParsedParameters parsedParameters = parsedSql.getParameters();
        this.getContext().setParsedSql(parsedSql);
        try {
            PreparedStatement stmt;
            try {
                StatementBuilder statementBuilder = this.getHandle().getStatementBuilder();
                Connection connection = this.getHandle().getConnection();
                stmt = statementBuilder.create(connection, sql, this.getContext());
                this.addCleanable(() -> statementBuilder.close(connection, sql, stmt));
            }
            catch (SQLException e) {
                throw new UnableToCreateStatementException(e, this.getContext());
            }
            this.beforeBinding(stmt);
            try {
                for (Binding binding : this.bindings) {
                    this.getContext().setBinding(binding);
                    ArgumentBinder.bind(parsedParameters, binding, stmt, this.getContext());
                    stmt.addBatch();
                }
            }
            catch (SQLException e) {
                throw new UnableToExecuteStatementException("Exception while binding parameters", e, this.getContext());
            }
            this.beforeExecution(stmt);
            try {
                long start = System.nanoTime();
                int[] rs = stmt.executeBatch();
                long elapsedTime = System.nanoTime() - start;
                LOG.trace("Prepared batch of {} parts executed in {}ms", new Object[]{this.bindings.size(), elapsedTime / 1000000L, parsedSql});
                this.getConfig(SqlStatements.class).getTimingCollector().collect(elapsedTime, this.getContext());
                this.afterExecution(stmt);
                this.getContext().setBinding(new Binding());
                ExecutedBatch executedBatch = new ExecutedBatch(stmt, rs);
                return executedBatch;
            }
            catch (SQLException e) {
                throw new UnableToExecuteStatementException(Batch.mungeBatchException(e), this.getContext());
            }
        }
        finally {
            this.bindings.clear();
        }
    }

    public PreparedBatch add() {
        Binding currentBinding = this.getBinding();
        if (currentBinding.isEmpty()) {
            throw new IllegalStateException("Attempt to add() a empty batch, you probably didn't mean to do this - call add() *after* setting batch parameters");
        }
        this.bindings.add(currentBinding);
        this.getContext().setBinding(new Binding());
        return this;
    }

    public PreparedBatch add(Object ... args) {
        for (int i = 0; i < args.length; ++i) {
            this.bind(i, args[i]);
        }
        this.add();
        return this;
    }

    public PreparedBatch add(Map<String, ?> args) {
        this.bindMap(args);
        this.add();
        return this;
    }

    public int size() {
        return this.bindings.size();
    }

    private static class ExecutedBatch {
        final PreparedStatement stmt;
        final int[] updateCounts;

        ExecutedBatch(PreparedStatement stmt, int[] updateCounts) {
            this.stmt = stmt;
            this.updateCounts = updateCounts;
        }
    }
}

